/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultivaluedMetadata {
    private HashMap<String, List<String>> data;

    public MultivaluedMetadata() {
        this.data = new HashMap();
    }

    public MultivaluedMetadata(HashMap<String, List<String>> data) {
        this.data = data;
    }

    public void put(String key, List<String> vals) {
        this.data.put(key.toLowerCase(), vals);
    }

    public void putSingle(String key, String value) {
        List<String> vals = this.data.get(key.toLowerCase());
        if (vals == null) {
            vals = new ArrayList<String>();
        }
        vals.add(value);
        this.put(key.toLowerCase(), vals);
    }

    public String getFirst(String key) {
        List<String> vals = this.data.get(key.toLowerCase());
        if (vals == null || vals.size() == 0) {
            return null;
        }
        return vals.get(0);
    }

    public HashMap<String, String> getAll() {
        HashMap<String, String> h = new HashMap<String, String>();
        Set<String> keys = this.data.keySet();
        for (String key : keys) {
            List<String> vals = this.data.get(key);
            if (vals == null) continue;
            h.put(key, this.convertToString(vals));
        }
        return h;
    }

    public String get(String key) {
        List<String> vals = this.getList(key.toLowerCase());
        if (vals != null) {
            return this.convertToString(vals);
        }
        return null;
    }

    public List<String> getList(String key) {
        return this.data.get(key.toLowerCase());
    }

    public Set<String> keys() {
        return this.data.keySet();
    }

    private String convertToString(List<String> list) {
        if (list.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String t : list) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(t);
        }
        return sb.toString();
    }
}

