/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.MultivaluedMetadata;
import org.exoplatform.services.rest.QueryTemplate;
import org.exoplatform.services.rest.URIPattern;
import org.exoplatform.services.rest.container.InvalidResourceDescriptorException;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.container.ResourceContainerResolvingStrategy;
import org.exoplatform.services.rest.container.ResourceDescriptor;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBinder
implements Startable {
    private List<ResourceDescriptor> resourceDescriptors_;
    private List<ResourceContainerResolvingStrategy> bindStrategies_;
    private ExoContainerContext containerContext_;
    private ExoContainer container_;
    private static final Log LOGGER = ExoLogger.getLogger((String)"ResourceBinder");

    public ResourceBinder(InitParams params, ExoContainerContext containerContext) throws Exception {
        this.containerContext_ = containerContext;
        this.resourceDescriptors_ = new ArrayList<ResourceDescriptor>();
        this.bindStrategies_ = new ArrayList<ResourceContainerResolvingStrategy>();
        Iterator i = params.getValueParamIterator();
        while (i.hasNext()) {
            ValueParam v = (ValueParam)i.next();
            ResourceContainerResolvingStrategy rs = (ResourceContainerResolvingStrategy)Class.forName(v.getValue()).newInstance();
            this.bindStrategies_.add(rs);
        }
    }

    public final void bind(ResourceContainer resourceCont) throws InvalidResourceDescriptorException {
        for (ResourceContainerResolvingStrategy strategy : this.bindStrategies_) {
            List<ResourceDescriptor> resList = strategy.resolve(resourceCont);
            this.validate(resList);
            this.resourceDescriptors_.addAll(resList);
            LOGGER.info((Object)("Bind new ResourceContainer: " + resourceCont));
            this.sortResourcesByURIParams(0, this.resourceDescriptors_.size() - 1);
        }
    }

    public final void unbind(ResourceContainer resourceCont) {
        int i = 0;
        ArrayList<ResourceDescriptor> tmp = new ArrayList<ResourceDescriptor>(this.resourceDescriptors_);
        for (ResourceDescriptor resource : tmp) {
            if (resource.getResourceContainer().equals(resourceCont)) {
                this.resourceDescriptors_.remove(i);
                continue;
            }
            ++i;
        }
    }

    public final void clear() {
        this.resourceDescriptors_.clear();
    }

    public final List<ResourceDescriptor> getAllDescriptors() {
        return this.resourceDescriptors_;
    }

    private void validate(List<ResourceDescriptor> newDescriptors) throws InvalidResourceDescriptorException {
        for (ResourceDescriptor newDescriptor : newDescriptors) {
            URIPattern newPattern = newDescriptor.getURIPattern();
            String newHTTPMethod = newDescriptor.getAcceptableMethod();
            MultivaluedMetadata newQueryPattern = newDescriptor.getQueryPattern();
            for (ResourceDescriptor storedDescriptor : this.resourceDescriptors_) {
                URIPattern srotedPattern = storedDescriptor.getURIPattern();
                String storedHTTPMethod = storedDescriptor.getAcceptableMethod();
                MultivaluedMetadata storedQueryPattern = storedDescriptor.getQueryPattern();
                if (!srotedPattern.matches(newPattern) && !newPattern.matches(srotedPattern) || !storedHTTPMethod.equalsIgnoreCase(newHTTPMethod) || !this.isQueryPatternMatches(storedQueryPattern, newQueryPattern)) continue;
                throw new InvalidResourceDescriptorException("The ResourceContainer \nmethod : " + newDescriptor.getServer().toGenericString() + "\nURITemplate : " + newDescriptor.getURIPattern().getString() + "\nHTTPMethod : " + newDescriptor.getAcceptableMethod() + "\nQueryTemplate : " + newDescriptor.getServer().getAnnotation(QueryTemplate.class) + "\ncan not be defined because of existed ResourceContainer " + "\nmethod : " + storedDescriptor.getServer().toGenericString() + "\nURITemplate : " + storedDescriptor.getURIPattern().getString() + "\nHTTPMethod : " + storedDescriptor.getAcceptableMethod() + "\nQueryTemplate : " + storedDescriptor.getServer().getAnnotation(QueryTemplate.class));
            }
            Method method = newDescriptor.getServer();
            Class<?>[] requestedParams = method.getParameterTypes();
            Annotation[][] paramAnno = method.getParameterAnnotations();
            boolean hasRequestEntity = false;
            for (int i = 0; i < paramAnno.length; ++i) {
                if (paramAnno[i].length == 0) {
                    if (method.getAnnotation(InputTransformer.class) == null && newDescriptor.getResourceContainer().getClass().getAnnotation(InputTransformer.class) == null) {
                        throw new InvalidResourceDescriptorException("One not annotated object found, but transformer in method : \n" + method.toGenericString() + "\nInputTransformer annotation is not specified. This is not allowed!");
                    }
                    if (!hasRequestEntity) {
                        hasRequestEntity = true;
                        continue;
                    }
                    throw new InvalidResourceDescriptorException("Only one not annotated object with must represent HTTP Request.\nIn method : " + method.toGenericString());
                }
                try {
                    requestedParams[i].getConstructor(String.class);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidResourceDescriptorException("All annotated parameters must have constructor with String or be the String.\nIn method : " + method.toGenericString());
                }
            }
        }
    }

    private boolean isQueryPatternMatches(MultivaluedMetadata storedQueryPattern, MultivaluedMetadata newQueryPattern) {
        Set<String> storedKeys = storedQueryPattern.keys();
        Set<String> newKeys = newQueryPattern.keys();
        if (newKeys.size() == 0 || storedKeys.size() == 0) {
            return true;
        }
        if (!storedKeys.containsAll(newKeys) && !newKeys.containsAll(storedKeys)) {
            return false;
        }
        for (String key : storedKeys) {
            List<String> s = storedQueryPattern.getList(key);
            List<String> n = newQueryPattern.getList(key);
            if (n == null || s.containsAll(n) && n.containsAll(s)) continue;
            return false;
        }
        return true;
    }

    private void sortResourcesByURIParams(int i0, int k0) {
        int i = i0;
        int k = k0;
        if (k0 > i0) {
            int middleElementParameterArrayLength = this.resourceDescriptors_.get((i0 + k0) / 2).getURIPattern().getParamNames().size();
            while (i <= k) {
                while (i < k0 && this.resourceDescriptors_.get(i).getURIPattern().getParamNames().size() > middleElementParameterArrayLength) {
                    ++i;
                }
                while (k > i0 && this.resourceDescriptors_.get(k).getURIPattern().getParamNames().size() < middleElementParameterArrayLength) {
                    --k;
                }
                if (i > k) continue;
                this.swapResources(i, k);
                ++i;
                --k;
            }
            if (i0 < k) {
                this.sortResourcesByURIParams(i0, k);
            }
            if (i < k0) {
                this.sortResourcesByURIParams(i, k0);
            }
        }
    }

    private void swapResources(int i, int k) {
        ResourceDescriptor temp = this.resourceDescriptors_.get(i);
        this.resourceDescriptors_.set(i, this.resourceDescriptors_.get(k));
        this.resourceDescriptors_.set(k, temp);
    }

    public void start() {
        this.container_ = this.containerContext_.getContainer();
        List list = this.container_.getComponentInstancesOfType(ResourceContainer.class);
        for (ResourceContainer c : list) {
            try {
                this.bind(c);
            }
            catch (InvalidResourceDescriptorException irde) {
                LOGGER.error((Object)("Can't add ResourceContainer Component: " + c.getClass().getName() + ".\nException : " + irde));
            }
        }
    }

    public void stop() {
        this.clear();
    }
}

