/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.rest.ConsumedMimeTypes;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.MultivaluedMetadata;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ProducedMimeTypes;
import org.exoplatform.services.rest.QueryTemplate;
import org.exoplatform.services.rest.URIPattern;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.container.ResourceContainerResolvingStrategy;
import org.exoplatform.services.rest.container.ResourceDescriptor;
import org.exoplatform.services.rest.data.QueryUtils;
import org.exoplatform.services.rest.transformer.InputEntityTransformer;
import org.exoplatform.services.rest.transformer.OutputEntityTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPAnnotatedContainerResolvingStrategy
implements ResourceContainerResolvingStrategy {
    @Override
    public final List<ResourceDescriptor> resolve(ResourceContainer resourceContainer) {
        ArrayList<ResourceDescriptor> resources = new ArrayList<ResourceDescriptor>();
        for (Method method : resourceContainer.getClass().getMethods()) {
            HTTPResourceDescriptor descr = this.methodMapping(method, resourceContainer);
            if (descr == null) continue;
            resources.add(descr);
        }
        return resources;
    }

    private HTTPResourceDescriptor methodMapping(Method method, ResourceContainer resourceCont) {
        String middleUri = this.middleUri(resourceCont.getClass());
        HTTPMethod httpMethodAnnotation = method.getAnnotation(HTTPMethod.class);
        URITemplate uriTemplateAnnotation = method.getAnnotation(URITemplate.class);
        if (!(httpMethodAnnotation == null || uriTemplateAnnotation == null && "".equals(middleUri))) {
            String uri = !"".equals(middleUri) ? this.glueUri(middleUri, uriTemplateAnnotation) : uriTemplateAnnotation.value();
            String httpMethodName = httpMethodAnnotation.value();
            return new HTTPResourceDescriptor(method, httpMethodName, uri, resourceCont);
        }
        return null;
    }

    private String glueUri(String middleUri, URITemplate u) {
        if (u == null) {
            return middleUri;
        }
        String uri = u.value();
        uri = middleUri.endsWith("/") && uri.startsWith("/") ? middleUri + uri.replaceFirst("/", "") : (!middleUri.endsWith("/") && !uri.startsWith("/") ? middleUri + "/" + uri : middleUri + uri);
        return uri;
    }

    private String middleUri(Class<? extends ResourceContainer> clazz) {
        URITemplate anno = clazz.getAnnotation(URITemplate.class);
        if (anno == null) {
            return "";
        }
        return anno.value();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HTTPResourceDescriptor
    implements ResourceDescriptor {
        private String httpMethodName;
        private URIPattern uriPattern;
        private String consumedMimeTypes;
        private String producedMimeTypes;
        private MultivaluedMetadata queryPattern;
        private Class<? extends InputEntityTransformer> inputTransformerType;
        private Class<? extends OutputEntityTransformer> outputTransformerType;
        private Method servingMethod;
        private Annotation[] methodParameterAnnotations;
        private Class<?>[] methodParameters;
        private ResourceContainer resourceContainer;

        public HTTPResourceDescriptor(Method method, String httpMethodName, String uri, ResourceContainer resourceContainer) {
            this.servingMethod = method;
            this.httpMethodName = httpMethodName;
            this.uriPattern = new URIPattern(uri);
            this.resourceContainer = resourceContainer;
            this.methodParameters = this.servingMethod.getParameterTypes();
            this.methodParameterAnnotations = this.resolveParametersAnnotations();
            ConsumedMimeTypes consumedMimeTypesAnnotation = method.getAnnotation(ConsumedMimeTypes.class);
            ProducedMimeTypes producedMimeTypesAnnotation = method.getAnnotation(ProducedMimeTypes.class);
            this.consumedMimeTypes = consumedMimeTypesAnnotation != null ? consumedMimeTypesAnnotation.value() : "*/*";
            this.producedMimeTypes = producedMimeTypesAnnotation != null ? producedMimeTypesAnnotation.value() : "*/*";
            QueryTemplate queryParamFilter = method.getAnnotation(QueryTemplate.class);
            this.queryPattern = queryParamFilter != null ? QueryUtils.parseQueryString(queryParamFilter.value()) : new MultivaluedMetadata();
            InputTransformer containerInputTransformer = resourceContainer.getClass().getAnnotation(InputTransformer.class);
            InputTransformer methodInputTransformer = method.getAnnotation(InputTransformer.class);
            if (containerInputTransformer != null && methodInputTransformer == null) {
                this.inputTransformerType = containerInputTransformer.value();
            } else if (methodInputTransformer != null) {
                this.inputTransformerType = methodInputTransformer.value();
            }
            OutputTransformer containerOutputTransformer = resourceContainer.getClass().getAnnotation(OutputTransformer.class);
            OutputTransformer methodOutputTransformer = method.getAnnotation(OutputTransformer.class);
            if (containerOutputTransformer != null && methodOutputTransformer == null) {
                this.outputTransformerType = containerOutputTransformer.value();
            } else if (methodOutputTransformer != null) {
                this.outputTransformerType = methodOutputTransformer.value();
            }
        }

        @Override
        public final ResourceContainer getResourceContainer() {
            return this.resourceContainer;
        }

        @Override
        public final Method getServer() {
            return this.servingMethod;
        }

        @Override
        public final Class<? extends InputEntityTransformer> getInputTransformerType() {
            return this.inputTransformerType;
        }

        @Override
        public final Class<? extends OutputEntityTransformer> getOutputTransformerType() {
            return this.outputTransformerType;
        }

        @Override
        public final Annotation[] getMethodParameterAnnotations() {
            return this.methodParameterAnnotations;
        }

        @Override
        public final Class<?>[] getMethodParameters() {
            return this.methodParameters;
        }

        @Override
        public final URIPattern getURIPattern() {
            return this.uriPattern;
        }

        @Override
        public final String getAcceptableMethod() {
            return this.httpMethodName;
        }

        @Override
        public final String getConsumedMimeTypes() {
            return this.consumedMimeTypes;
        }

        @Override
        public final String getProducedMimeTypes() {
            return this.producedMimeTypes;
        }

        @Override
        public final MultivaluedMetadata getQueryPattern() {
            return this.queryPattern;
        }

        private Annotation[] resolveParametersAnnotations() {
            Annotation[][] a = this.servingMethod.getParameterAnnotations();
            Annotation[] anno = new Annotation[a.length];
            for (int i = 0; i < a.length; ++i) {
                if (a[i].length <= 0) continue;
                anno[i] = a[i][0];
            }
            return anno;
        }
    }
}

