/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.services.rest.MultivaluedMetadata;
import org.exoplatform.services.rest.Request;
import org.exoplatform.services.rest.ResourceIdentifier;

public class RequestFactory {
    private RequestFactory() {
    }

    public static Request createRequest(HttpServletRequest httpRequest) throws IOException {
        String pathInfo = httpRequest.getPathInfo();
        String method = httpRequest.getMethod();
        MultivaluedMetadata headerParams = RequestFactory.parseHttpHeaders(httpRequest);
        MultivaluedMetadata queryParams = RequestFactory.parseQueryParams(httpRequest);
        ServletInputStream in = httpRequest.getInputStream();
        String port = httpRequest.getServerPort() == 80 ? "" : ":" + httpRequest.getServerPort();
        String baseURI = httpRequest.getScheme() + "://" + httpRequest.getServerName() + port + httpRequest.getContextPath() + httpRequest.getServletPath();
        ResourceIdentifier identifier = new ResourceIdentifier(httpRequest.getServerName(), baseURI, pathInfo);
        return new Request((InputStream)in, identifier, method, headerParams, queryParams);
    }

    private static MultivaluedMetadata parseHttpHeaders(HttpServletRequest httpRequest) {
        MultivaluedMetadata headerParams = new MultivaluedMetadata();
        Enumeration temp = httpRequest.getHeaderNames();
        while (temp.hasMoreElements()) {
            String k = (String)temp.nextElement();
            Enumeration e = httpRequest.getHeaders(k);
            while (e.hasMoreElements()) {
                headerParams.putSingle(k, (String)e.nextElement());
            }
        }
        return headerParams;
    }

    private static MultivaluedMetadata parseQueryParams(HttpServletRequest httpRequest) {
        MultivaluedMetadata queryParams = new MultivaluedMetadata();
        Enumeration temp = httpRequest.getParameterNames();
        while (temp.hasMoreElements()) {
            String k = (String)temp.nextElement();
            String[] params = httpRequest.getParameterValues(k);
            for (int i = 0; i < params.length; ++i) {
                queryParams.putSingle(k, params[i]);
            }
        }
        return queryParams;
    }
}

