/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.transformer;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.services.rest.transformer.OutputEntityTransformer;
import org.exoplatform.services.rest.transformer.XSLTConstants;
import org.exoplatform.services.xml.transform.NotSupportedIOTypeException;
import org.exoplatform.services.xml.transform.trax.TRAXTemplatesService;
import org.exoplatform.services.xml.transform.trax.TRAXTransformer;

public class XSLT4SourceOutputTransformer
extends OutputEntityTransformer {
    private TRAXTemplatesService templatesService_;

    public XSLT4SourceOutputTransformer(TRAXTemplatesService templatesService) {
        super(new Object[0]);
        this.templatesService_ = templatesService;
    }

    public void writeTo(Object entity, OutputStream entityDataStream) throws IOException {
        Source e = (Source)entity;
        String xsltTemplate = (String)this.transformerParameters_.get(XSLTConstants.XSLT_TEMPLATE);
        try {
            TRAXTransformer transformer = null;
            if (xsltTemplate == null) {
                throw new TransformerConfigurationException("Can't get parameter '" + XSLTConstants.XSLT_TEMPLATE + "' from OutputTransformer parameters.\n" + "It can be set from ResourceContainer, see : " + "org.exoplatform.services.rest.Response.Builder#setTransformerParameters(trfParams)");
            }
            transformer = this.templatesService_.getTemplates(xsltTemplate).newTransformer();
            transformer.initResult((Result)new StreamResult(entityDataStream));
            transformer.transform(e);
        }
        catch (TransformerConfigurationException tce) {
            throw new IOException("Can't write to output stream " + tce);
        }
        catch (NotSupportedIOTypeException nse) {
            throw new IOException("Can't write to output stream " + (Object)((Object)nse));
        }
        catch (TransformerException tre) {
            throw new IOException("Can't write to output stream " + tre);
        }
    }
}

