/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class RegistryEntry {
    private Document document;

    public RegistryEntry(Document dom) {
        this.document = dom;
    }

    public RegistryEntry(String rootName) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.document = db.newDocument();
        Element nodeElement = this.document.createElement(rootName);
        this.document.appendChild(nodeElement);
    }

    public static RegistryEntry parse(byte[] bytes) throws IOException, SAXException, ParserConfigurationException {
        return new RegistryEntry(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(bytes)));
    }

    public static RegistryEntry parse(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        return new RegistryEntry(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in));
    }

    public InputStream getAsInputStream() throws TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.document), new StreamResult(out));
        return new ByteArrayInputStream(out.toByteArray());
    }

    public String getName() {
        return this.document.getDocumentElement().getNodeName();
    }

    public Document getDocument() {
        return this.document;
    }
}

