/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.replication.PersistentWorkspaceDataReceiver;
import org.exoplatform.services.jcr.ext.replication.ProxyWorkspaceDataReceiver;
import org.exoplatform.services.jcr.ext.replication.WorkspaceDataManagerProxy;
import org.exoplatform.services.jcr.ext.replication.WorkspaceDataTransmitter;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.MessageDispatcher;
import org.picocontainer.Startable;

public class ReplicationService
implements Startable {
    protected static Log log = ExoLogger.getLogger((String)"ext.ReplicationService");
    private static final String IP_ADRESS_TEMPLATE = "[$]bind-ip-address";
    private static final String PERSISTENT_MODE = "persistent";
    private static final String PROXY_MODE = "proxy";
    private RepositoryService repoService;
    private String testMode;
    private String enabled;
    private String mode;
    private String bindIPAdaress;
    private String channelConfig;
    private List<String> repoNamesList;

    public ReplicationService(RepositoryService repoService, InitParams params) throws RepositoryConfigurationException {
        this.repoService = repoService;
        PropertiesParam pps = params.getPropertiesParam("replication-properties");
        this.testMode = pps.getProperty("test-mode");
        this.enabled = pps.getProperty("enabled");
        if (this.enabled == null) {
            throw new RepositoryConfigurationException("enabled not specified");
        }
        this.mode = pps.getProperty("mode");
        if (this.mode == null) {
            throw new RepositoryConfigurationException("mode not specified");
        }
        if (!this.mode.equals(PERSISTENT_MODE) && !this.mode.equals(PROXY_MODE)) {
            throw new RepositoryConfigurationException("Parameter 'mode' (persistent|proxy) required for replication configuration");
        }
        this.bindIPAdaress = pps.getProperty("bind-ip-address");
        if (this.bindIPAdaress == null) {
            throw new RepositoryConfigurationException("bind-ip-address not specified");
        }
        this.channelConfig = pps.getProperty("channel-config");
        if (this.channelConfig == null) {
            throw new RepositoryConfigurationException("channel-config not specified");
        }
        ValuesParam vp = params.getValuesParam("repositories");
        if (vp == null || vp.getValues().size() == 0) {
            throw new RepositoryConfigurationException("repositories not specified");
        }
        this.repoNamesList = vp.getValues();
    }

    public void start() {
        if (this.enabled.equals("true")) {
            try {
                for (int rIndex = 0; rIndex < this.repoNamesList.size(); ++rIndex) {
                    RepositoryImpl jcrRepository = (RepositoryImpl)this.repoService.getRepository(this.repoNamesList.get(rIndex));
                    String[] workspaces = jcrRepository.getWorkspaceNames();
                    for (int wIndex = 0; wIndex < workspaces.length; ++wIndex) {
                        try {
                            String systemId = IdGenerator.generate();
                            String props = this.channelConfig.replaceAll(IP_ADRESS_TEMPLATE, this.bindIPAdaress);
                            JChannel channel = new JChannel(props);
                            MessageDispatcher disp = new MessageDispatcher((Channel)channel, null, null, null);
                            WorkspaceContainer wContainer = (WorkspaceContainer)jcrRepository.getSystemSession(workspaces[wIndex]).getContainer();
                            wContainer.registerComponentImplementation(WorkspaceDataTransmitter.class);
                            WorkspaceDataTransmitter dataTransmitter = (WorkspaceDataTransmitter)wContainer.getComponentInstanceOfType(WorkspaceDataTransmitter.class);
                            dataTransmitter.init(disp, systemId);
                            String uniqueNoame = this.getUniqueName(jcrRepository.getConfiguration(), workspaces[wIndex]);
                            if (this.testMode != null && "true".equals(this.testMode)) {
                                uniqueNoame = "Test_Channel";
                            }
                            if (this.mode.equals(PROXY_MODE)) {
                                wContainer.registerComponentImplementation(WorkspaceDataManagerProxy.class);
                                wContainer.registerComponentImplementation(ProxyWorkspaceDataReceiver.class);
                                ProxyWorkspaceDataReceiver proxyDataReceiver = (ProxyWorkspaceDataReceiver)wContainer.getComponentInstanceOfType(ProxyWorkspaceDataReceiver.class);
                                proxyDataReceiver.init(disp, systemId);
                            } else if (this.mode.equals(PERSISTENT_MODE)) {
                                wContainer.registerComponentImplementation(PersistentWorkspaceDataReceiver.class);
                                PersistentWorkspaceDataReceiver persistentDataReceiver = (PersistentWorkspaceDataReceiver)wContainer.getComponentInstanceOfType(PersistentWorkspaceDataReceiver.class);
                                persistentDataReceiver.init(disp, systemId);
                            }
                            channel.connect(uniqueNoame);
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)("Can not start replication on " + this.repoNamesList.get(rIndex) + "_" + workspaces[wIndex] + " \n" + e), (Throwable)e);
                        }
                    }
                }
            }
            catch (RepositoryException re) {
                log.error((Object)("Can not start ReplicationService \n" + (Object)((Object)re)), (Throwable)re);
            }
            catch (RepositoryConfigurationException e) {
                log.error((Object)("Can not start ReplicationService \n" + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    private String getUniqueName(RepositoryEntry configuration, String workspaceName) {
        List wEntrys = configuration.getWorkspaceEntries();
        for (WorkspaceEntry wEntry : wEntrys) {
            if (!workspaceName.equals(wEntry.getName())) continue;
            return wEntry.getUniqueName();
        }
        return null;
    }

    public void stop() {
    }
}

