/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Properties;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;

public class MSExcelDocumentReader
extends BaseDocumentReader {
    public String[] getMimeTypes() {
        return new String[]{"application/excel", "application/xls"};
    }

    public String getContentAsText(InputStream is) throws Exception {
        String text = "";
        try {
            HSSFWorkbook wb = new HSSFWorkbook(is);
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                if (sheet == null) continue;
                for (int j = 0; j < sheet.getPhysicalNumberOfRows(); ++j) {
                    HSSFRow row = sheet.getRow(j);
                    block11: for (int k = 0; k < row.getPhysicalNumberOfCells(); ++k) {
                        HSSFCell cell = row.getCell((short)k);
                        switch (cell.getCellType()) {
                            case 0: {
                                double d = cell.getNumericCellValue();
                                if (MSExcelDocumentReader.isCellDateFormatted(cell)) {
                                    Calendar cal = null;
                                    cal.setTime(HSSFDateUtil.getJavaDate((double)d));
                                    String cellText = "";
                                    cellText = String.valueOf(cal.get(1)).substring(2);
                                    cellText = cal.get(2) + 1 + "/" + cal.get(5) + "/" + cellText;
                                    continue block11;
                                }
                                text = text + d + " \n";
                                continue block11;
                            }
                            case 2: {
                                text = text + cell.getCellFormula().toString() + " ";
                                continue block11;
                            }
                            case 4: {
                                text = text + cell.getBooleanCellValue() + " ";
                                continue block11;
                            }
                            case 5: {
                                text = text + cell.getErrorCellValue() + " ";
                                continue block11;
                            }
                            case 1: {
                                text = text + cell.getStringCellValue().toString() + " ";
                                continue block11;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    public Properties getProperties(InputStream is) throws Exception {
        POIPropertiesReader reader = new POIPropertiesReader();
        reader.readDCProperties(is);
        return reader.getProperties();
    }

    public static boolean isCellDateFormatted(HSSFCell cell) {
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (HSSFDateUtil.isValidExcelDate((double)d)) {
            HSSFCellStyle style = cell.getCellStyle();
            short i = style.getDataFormat();
            switch (i) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 45: 
                case 46: 
                case 47: {
                    bDate = true;
                    break;
                }
                default: {
                    bDate = false;
                }
            }
        }
        return bDate;
    }
}

