/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.config;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.exoplatform.commons.xml.ExoXMLSerializer;
import org.exoplatform.services.portletcontainer.PortletContainer;
import org.exoplatform.services.portletcontainer.config.Cache;
import org.exoplatform.services.portletcontainer.config.CustomMode;
import org.exoplatform.services.portletcontainer.config.CustomWindowState;
import org.exoplatform.services.portletcontainer.config.Description;
import org.exoplatform.services.portletcontainer.config.Global;
import org.exoplatform.services.portletcontainer.config.Properties;
import org.exoplatform.services.portletcontainer.config.SupportedContent;

public class XMLSerializer {
    private static String pcNS = "";

    protected XMLSerializer() {
    }

    public static void toXML(ExoXMLSerializer ser, PortletContainer pc) throws Exception {
        int i;
        ser.startTag(pcNS, "global");
        XMLSerializer.toXML(ser, pc.getGlobal());
        ser.endTag(pcNS, "global");
        ser.startTag(pcNS, "cache");
        XMLSerializer.toXML(ser, pc.getCache());
        ser.endTag(pcNS, "cache");
        List<Object> list = pc.getSupportedContent();
        for (i = 0; i < list.size(); ++i) {
            ser.startTag(pcNS, "supported-content");
            ser.element(pcNS, "name", ((SupportedContent)list.get(i)).getName());
            ser.endTag(pcNS, "supported-content");
        }
        list = pc.getCustomMode();
        for (i = 0; i < list.size(); ++i) {
            ser.startTag(pcNS, "custom-mode");
            XMLSerializer.toXML(ser, (CustomMode)list.get(i));
            ser.endTag(pcNS, "custom-mode");
        }
        list = pc.getCustomWindowState();
        for (i = 0; i < list.size(); ++i) {
            ser.startTag(pcNS, "custom-window-state");
            XMLSerializer.toXML(ser, (CustomWindowState)list.get(i));
            ser.endTag(pcNS, "custom-window-state");
        }
        list = pc.getProperties();
        for (i = 0; i < list.size(); ++i) {
            ser.startTag(pcNS, "properties");
            XMLSerializer.toXML(ser, (Properties)list.get(i));
            ser.endTag(pcNS, "properties");
        }
    }

    public static void toXML(ExoXMLSerializer ser, Global global) throws Exception {
        ser.element(pcNS, "name", global.getName());
        ser.element(pcNS, "description", global.getDescription());
        ser.element(pcNS, "major-version", Integer.toString(global.getMajorVersion()));
        ser.element(pcNS, "minor-version", Integer.toString(global.getMinorVersion()));
    }

    public static void toXML(ExoXMLSerializer ser, Cache cache) throws Exception {
        ser.element(pcNS, "enable", cache.getEnable());
    }

    public static void toXML(ExoXMLSerializer ser, CustomMode mode) throws Exception {
        ser.element(pcNS, "name", mode.getName());
        List<Description> descs = mode.getDescription();
        for (int i = 0; i < descs.size(); ++i) {
            XMLSerializer.toXML(ser, descs.get(i));
        }
    }

    public static void toXML(ExoXMLSerializer ser, CustomWindowState state) throws Exception {
        ser.element(pcNS, "name", state.getName());
        List<Description> descs = state.getDescription();
        for (int i = 0; i < descs.size(); ++i) {
            XMLSerializer.toXML(ser, descs.get(i));
        }
    }

    public static void toXML(ExoXMLSerializer ser, Properties props) throws Exception {
        ser.element(pcNS, "description", props.getName());
        ser.element(pcNS, "name", props.getName());
        ser.element(pcNS, "value", props.getValue());
    }

    public static void toXML(ExoXMLSerializer ser, Description desc) throws Exception {
        ser.startTag(pcNS, "description");
        ser.attribute(pcNS, "lang", desc.getLang());
        ser.text(desc.getDescription());
        ser.endTag(pcNS, "description");
    }

    public static String toXML(PortletContainer pc) throws Exception {
        ExoXMLSerializer ser = ExoXMLSerializer.getInstance();
        StringWriter sw = new StringWriter();
        ser.setOutput((Writer)sw);
        ser.startDocument("UTF-8", null);
        ser.text("\n");
        ser.startTag(pcNS, "portlet-container");
        XMLSerializer.toXML(ser, pc);
        ser.endTag(pcNS, "portlet-container");
        ser.endDocument();
        return sw.getBuffer().toString();
    }
}

