/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.pci.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.filter.FilterChain;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.exoplatform.Constants;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.pci.model.Description;
import org.exoplatform.services.portletcontainer.pci.model.DisplayName;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.InitParam;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.pci.model.PortletInfo;
import org.exoplatform.services.portletcontainer.pci.model.SecurityRoleRef;
import org.exoplatform.services.portletcontainer.pci.model.SharedSessionAttribute;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.pci.model.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Portlet {
    private List<Description> description;
    private String portletName;
    private List<DisplayName> displayName = new ArrayList<DisplayName>();
    private String portletClass;
    private List<InitParam> initParam;
    private Integer caching;
    private List<Supports> supports;
    private List<Locale> supportedLocale;
    private String resourceBundle;
    private PortletInfo portletInfo;
    private ExoPortletPreferences portletPreferences;
    private List<SecurityRoleRef> securityRoleRef;
    private String id;
    private List<QName> supportedProcessingEvent;
    private List<QName> supportedPublishingEvent;
    private List<String> supportedPublicRenderParameter;
    private Map<String, String[]> containerRuntimeOption;
    private List<SharedSessionAttribute> sharedSessionAttribute;
    private FilterChain filterChain = null;
    private PortletApp application;
    private String globalCache;
    private Boolean escapeXml;

    public final PortletApp getApplication() {
        return this.application;
    }

    public final void setApplication(PortletApp app) {
        this.application = app;
    }

    public final void setEscapeXml(Boolean escapeXml) {
        this.escapeXml = escapeXml;
    }

    public final void setEscapeXml(boolean escapeXml) {
        this.escapeXml = new Boolean(escapeXml);
    }

    public final Boolean getEscapeXml() {
        String[] valuesPortlet;
        if (this.escapeXml != null) {
            return this.escapeXml;
        }
        if (this.getContainerRuntimeOption() != null && (valuesPortlet = this.getContainerRuntimeOption().get("javax.portlet.escapeXml")) != null) {
            return new Boolean(valuesPortlet[0]);
        }
        String[] valuesApplication = null;
        if (this.application != null && this.application.getContainerRuntimeOption() != null) {
            valuesApplication = this.application.getContainerRuntimeOption().get("javax.portlet.escapeXml");
        }
        if (valuesApplication != null) {
            return new Boolean((String)valuesApplication[0]);
        }
        return Boolean.TRUE;
    }

    public final int getPortletSessionScope() {
        String[] valuesPortlet;
        if (this.getContainerRuntimeOption() != null && (valuesPortlet = this.getContainerRuntimeOption().get("javax.portlet.includedPortletSessionScope")) != null && valuesPortlet[0].equals("PORTLET_SCOPE")) {
            return 2;
        }
        String[] valuesApplication = this.application.getContainerRuntimeOption().get("javax.portlet.includedPortletSessionScope");
        if (valuesApplication != null && valuesApplication[0].equals("PORTLET_SCOPE")) {
            return 2;
        }
        return 1;
    }

    public final FilterChain getFilterChain() {
        return this.filterChain;
    }

    public final void setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
    }

    public final List<Description> getDescription() {
        if (this.description == null) {
            return Constants.EMPTY_LIST;
        }
        return this.description;
    }

    public final String getDescription(String lang) {
        return Util.getDescription(lang, this.description);
    }

    public final void setDescription(List<Description> description) {
        this.description = description;
    }

    public final void addDescription(Description desc) {
        if (this.description == null) {
            this.description = new ArrayList<Description>();
        }
        this.description.add(desc);
    }

    public final List<DisplayName> getDisplayName() {
        return this.displayName;
    }

    public final void addDisplayName(DisplayName name) {
        this.displayName.add(name);
    }

    public final void setDisplayName(List<DisplayName> displayName) {
        this.displayName = displayName;
    }

    public final Integer getCaching() {
        return this.caching;
    }

    public final void setCaching(Integer caching) {
        this.caching = caching;
    }

    public final String getGlobalCache() {
        return this.globalCache;
    }

    public final void setGlobalCache(String globalCache) {
        this.globalCache = globalCache;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final List<InitParam> getInitParam() {
        if (this.initParam == null) {
            return Constants.EMPTY_LIST;
        }
        return this.initParam;
    }

    public final void setInitParam(List<InitParam> initParam) {
        this.initParam = initParam;
    }

    public final void addInitParam(InitParam param) {
        if (this.initParam == null) {
            this.initParam = new ArrayList<InitParam>();
        }
        if (this.initParam.contains(param)) {
            Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
            log.error((Object)"Duplicate field \"init-param\" in portlet description");
        } else {
            this.initParam.add(param);
        }
    }

    public final String getPortletClass() {
        return this.portletClass;
    }

    public final void setPortletClass(String portletClass) {
        this.portletClass = portletClass;
    }

    public final PortletInfo getPortletInfo() {
        return this.portletInfo;
    }

    public final void setPortletInfo(PortletInfo portletInfo) {
        this.portletInfo = portletInfo;
    }

    public final String getPortletName() {
        return this.portletName;
    }

    public final void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    public final ExoPortletPreferences getPortletPreferences() {
        return this.portletPreferences;
    }

    public final void setPortletPreferences(ExoPortletPreferences portletPreferences) {
        this.portletPreferences = portletPreferences;
    }

    public final String getResourceBundle() {
        return this.resourceBundle;
    }

    public final void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public final List<SecurityRoleRef> getSecurityRoleRef() {
        if (this.securityRoleRef == null) {
            return Constants.EMPTY_LIST;
        }
        return this.securityRoleRef;
    }

    public final void setSecurityRoleRef(List<SecurityRoleRef> securityRoleRef) {
        this.securityRoleRef = securityRoleRef;
    }

    public final void addSecurityRoleRef(SecurityRoleRef ref) {
        if (this.securityRoleRef == null) {
            this.securityRoleRef = new ArrayList<SecurityRoleRef>();
        }
        if (this.securityRoleRef.contains(ref)) {
            Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
            log.error((Object)"Duplicate field \"security-role-ref\" in portlet description");
        } else {
            this.securityRoleRef.add(ref);
        }
    }

    public final List<Locale> getSupportedLocale() {
        if (this.supportedLocale == null) {
            return Constants.EMPTY_LIST;
        }
        return this.supportedLocale;
    }

    public final void setSupportedLocale(List<Locale> supportedLocale) {
        this.supportedLocale = supportedLocale;
    }

    public final void addSupportedLocale(Locale value) {
        if (this.supportedLocale == null) {
            this.supportedLocale = new ArrayList<Locale>();
        }
        this.supportedLocale.add(value);
    }

    public final List<Supports> getSupports() {
        if (this.supports == null) {
            return Constants.EMPTY_LIST;
        }
        return this.supports;
    }

    public final void setSupports(Supports s) {
        if (this.supports == null) {
            this.supports = new ArrayList<Supports>();
        }
        if (this.supports.contains(s)) {
            Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
            log.error((Object)"Duplicate field \"supports\" in portlet description");
        } else {
            this.supports.add(s);
        }
    }

    public final void addSupports(Supports s) {
        if (this.supports == null) {
            this.supports = new ArrayList<Supports>();
        }
        this.supports.add(s);
    }

    public final List<SharedSessionAttribute> getSharedSessionAttribute() {
        return this.sharedSessionAttribute;
    }

    public final void addSharedSessionAttribute(SharedSessionAttribute ssa) {
        if (this.sharedSessionAttribute == null) {
            this.sharedSessionAttribute = new ArrayList<SharedSessionAttribute>();
        }
        this.sharedSessionAttribute.add(ssa);
    }

    public final List<QName> getSupportedProcessingEvent() {
        return this.supportedProcessingEvent;
    }

    public final void setSupportedProcessingEvent(List<QName> list) {
        this.supportedProcessingEvent = list;
    }

    public final void addSupportedProcessingEvent(QName spe) {
        if (this.supportedProcessingEvent == null) {
            this.supportedProcessingEvent = new ArrayList<QName>();
        }
        if (this.supportedProcessingEvent.contains(spe)) {
            Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
            log.error((Object)"Duplicate field \"supported-processing-event\" in portlet description");
        } else {
            this.supportedProcessingEvent.add(spe);
        }
    }

    public final List<QName> getSupportedPublishingEvent() {
        return this.supportedPublishingEvent;
    }

    public final void setSupportedPublishingEvent(List<QName> list) {
        this.supportedPublishingEvent = list;
    }

    public final void addSupportedPublishingEvent(QName spe) {
        if (this.supportedPublishingEvent == null) {
            this.supportedPublishingEvent = new ArrayList<QName>();
        }
        if (this.supportedPublishingEvent.contains(spe)) {
            Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
            log.error((Object)"Duplicate field \"supported-publishing-event\" in portlet description");
        } else {
            this.supportedPublishingEvent.add(spe);
        }
    }

    public final List<String> getSupportedPublicRenderParameter() {
        return this.supportedPublicRenderParameter;
    }

    public final void addSupportedPublicRenderParameter(String srp) {
        if (this.supportedPublicRenderParameter == null) {
            this.supportedPublicRenderParameter = new ArrayList<String>();
        }
        if (this.supportedPublicRenderParameter.contains(srp)) {
            Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
            log.error((Object)"Duplicate field \"supported-public-render-parameter\" in portlet description");
        } else {
            this.supportedPublicRenderParameter.add(srp);
        }
    }

    public final void setContainerRuntimeOption(Map<String, String[]> containerRuntimeOption1) {
        this.containerRuntimeOption = containerRuntimeOption1 == null ? new HashMap<String, String[]>() : containerRuntimeOption1;
    }

    public final Map<String, String[]> getContainerRuntimeOption() {
        return this.containerRuntimeOption;
    }

    public final void addContainerRuntimeOption(String name, String[] value) {
        if (this.containerRuntimeOption == null) {
            this.containerRuntimeOption = new HashMap<String, String[]>();
        }
        this.containerRuntimeOption.put(name, value);
    }

    public final void addContainerRuntimeOption(Map<String, String[]> containerRuntimeOption1) {
        if (containerRuntimeOption1 == null) {
            this.containerRuntimeOption = new HashMap<String, String[]>();
        } else {
            this.containerRuntimeOption.putAll(containerRuntimeOption1);
        }
    }
}

