/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.pci.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.exoplatform.Constants;
import org.exoplatform.commons.xml.ExoXPPParser;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.pci.model.CustomPortletMode;
import org.exoplatform.services.portletcontainer.pci.model.CustomWindowState;
import org.exoplatform.services.portletcontainer.pci.model.Description;
import org.exoplatform.services.portletcontainer.pci.model.DisplayName;
import org.exoplatform.services.portletcontainer.pci.model.EventDefinition;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.Filter;
import org.exoplatform.services.portletcontainer.pci.model.FilterMapping;
import org.exoplatform.services.portletcontainer.pci.model.InitParam;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.pci.model.PortletCollection;
import org.exoplatform.services.portletcontainer.pci.model.PortletInfo;
import org.exoplatform.services.portletcontainer.pci.model.Preference;
import org.exoplatform.services.portletcontainer.pci.model.PublicRenderParameter;
import org.exoplatform.services.portletcontainer.pci.model.SecurityConstraint;
import org.exoplatform.services.portletcontainer.pci.model.SecurityRoleRef;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.pci.model.UserAttribute;
import org.exoplatform.services.portletcontainer.pci.model.UserDataConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLParser {
    private static boolean newSpec = false;
    private static PortletApp portletapp;

    protected XMLParser() {
    }

    public static PortletApp parse(InputStream is) throws Exception {
        ExoXPPParser xpp = ExoXPPParser.getInstance();
        xpp.setInput(is, "UTF8");
        xpp.mandatoryNode("portlet-app");
        return XMLParser.readPortletApp(xpp);
    }

    public static PortletApp parse(InputStream is, boolean isnewer) throws Exception {
        newSpec = isnewer;
        ExoXPPParser xpp = ExoXPPParser.getInstance();
        xpp.setInput(is, "UTF8");
        xpp.mandatoryNode("portlet-app");
        return XMLParser.readPortletApp(xpp);
    }

    public static PortletApp readPortletApp(ExoXPPParser xpp) throws Exception {
        portletapp = new PortletApp();
        portletapp.setVer2(newSpec);
        portletapp.setVersion(xpp.getNodeAttributeValue("version"));
        portletapp.setId(xpp.getNodeAttributeValue("id"));
        while (xpp.node("portlet")) {
            portletapp.addPortlet(XMLParser.readPortlet(xpp));
        }
        while (xpp.node("custom-portlet-mode")) {
            portletapp.addCustomPortletMode(XMLParser.readCustomPortletMode(xpp));
        }
        while (xpp.node("custom-window-state")) {
            portletapp.addCustomWindowState(XMLParser.readCustomWindowState(xpp));
        }
        while (xpp.node("user-attribute")) {
            portletapp.addUserAttribute(XMLParser.readUserAttribute(xpp));
        }
        while (xpp.node("security-constraint")) {
            portletapp.addSecurityConstraint(XMLParser.readSecurityConstraint(xpp));
        }
        if (newSpec) {
            if (xpp.node("resource-bundle")) {
                portletapp.setResourceBundle(xpp.getContent().trim());
            }
            while (xpp.node("filter")) {
                portletapp.addFilter(XMLParser.readFilter(xpp));
            }
            while (xpp.node("filter-mapping")) {
                portletapp.addFilterMapping(XMLParser.readFilterMapping(xpp));
            }
            if (xpp.node("default-namespace")) {
                portletapp.setDefaultNamespace(xpp.getContent().trim());
            }
            XMLParser.fillPredefinedEvents(portletapp);
            while (xpp.node("event-definition")) {
                portletapp.addEventDefinition(XMLParser.readEventDefinition(xpp));
            }
            while (xpp.node("public-render-parameter")) {
                portletapp.addPublicRenderParameter(XMLParser.readPublicRenderParameter(xpp));
            }
            while (xpp.node("listener")) {
                portletapp.addUrlGenerationListener(XMLParser.readUrlListener(xpp));
            }
            while (xpp.node("container-runtime-option")) {
                portletapp.addContainerRuntimeOption(XMLParser.readContainerRuntimeOption(xpp));
            }
        }
        if (!portletapp.getDefaultNamespace().equals("")) {
            String whatToFind = "";
            String whatToReplaceTo = portletapp.getDefaultNamespace();
            List<EventDefinition> events = portletapp.getEventDefinition();
            for (EventDefinition ed : events) {
                if (ed.getPrefferedName().getNamespaceURI().equals(whatToFind)) {
                    ed.setPrefferedName(new QName(whatToReplaceTo, ed.getPrefferedName().getLocalPart()));
                }
                ed.setAliases(XMLParser.setNamespaceIfAbsent(whatToFind, whatToReplaceTo, ed.getAliases()));
            }
            List<Portlet> plts = portletapp.getPortlet();
            for (Portlet p : plts) {
                p.setSupportedProcessingEvent(XMLParser.setNamespaceIfAbsent(whatToFind, whatToReplaceTo, p.getSupportedProcessingEvent()));
                p.setSupportedPublishingEvent(XMLParser.setNamespaceIfAbsent(whatToFind, whatToReplaceTo, p.getSupportedPublishingEvent()));
            }
        }
        return portletapp;
    }

    private static List<QName> setNamespaceIfAbsent(String whatToFind, String whatToReplaceTo, List<QName> aliases) {
        if (aliases == null) {
            return null;
        }
        ArrayList<QName> newAliases = new ArrayList<QName>();
        for (QName alias : aliases) {
            if (alias.getNamespaceURI().equals(whatToFind)) {
                newAliases.add(new QName(whatToReplaceTo, alias.getLocalPart()));
                continue;
            }
            newAliases.add(alias);
        }
        return newAliases;
    }

    public static Portlet readPortlet(ExoXPPParser xpp) throws Exception {
        Portlet p = new Portlet();
        p.setId(xpp.getNodeAttributeValue("id"));
        while (xpp.node("description")) {
            p.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("portlet-name");
        p.setPortletName(xpp.getContent());
        while (xpp.node("display-name")) {
            p.addDisplayName(XMLParser.readDisplayName(xpp));
        }
        xpp.mandatoryNode("portlet-class");
        p.setPortletClass(xpp.getContent().trim());
        while (xpp.node("init-param")) {
            p.addInitParam(XMLParser.readInitParam(xpp));
        }
        if (newSpec) {
            if (xpp.node("expiration-cache")) {
                p.setCaching(Integer.parseInt(xpp.getContent().trim()));
            } else {
                p.setCaching(null);
            }
            if (xpp.node("cache-scope") && xpp.getContent().trim().equalsIgnoreCase("public")) {
                p.setGlobalCache("true");
            } else {
                p.setGlobalCache("false");
            }
        } else if (xpp.node("expiration-cache")) {
            p.setCaching(Integer.parseInt(xpp.getContent().trim()));
        }
        xpp.mandatoryNode("supports");
        p.setSupports(XMLParser.readSupports(xpp));
        while (xpp.node("supports")) {
            p.addSupports(XMLParser.readSupports(xpp));
        }
        while (xpp.node("supported-locale")) {
            p.addSupportedLocale(new Locale(xpp.getContent().trim()));
        }
        if (xpp.node("resource-bundle")) {
            p.setResourceBundle(xpp.getContent().trim());
        }
        if (xpp.node("portlet-info")) {
            p.setPortletInfo(XMLParser.readPortletInfo(xpp));
        }
        if (xpp.node("portlet-preferences")) {
            p.setPortletPreferences(XMLParser.readPortletPreferences(xpp));
        }
        while (xpp.node("security-role-ref")) {
            p.addSecurityRoleRef(XMLParser.readSecurityRoleRef(xpp));
        }
        if (!newSpec && xpp.node("global-cache")) {
            p.setGlobalCache(xpp.getContent().trim());
        }
        if (newSpec) {
            while (xpp.node("supported-processing-event")) {
                p.addSupportedProcessingEvent(XMLParser.readEventReference(xpp));
            }
            while (xpp.node("supported-publishing-event")) {
                p.addSupportedPublishingEvent(XMLParser.readEventReference(xpp));
            }
            while (xpp.node("supported-public-render-parameter")) {
                p.addSupportedPublicRenderParameter(xpp.getContent().trim());
            }
            while (xpp.node("container-runtime-option")) {
                p.addContainerRuntimeOption(XMLParser.readContainerRuntimeOption(xpp));
            }
        }
        return p;
    }

    public static CustomPortletMode readCustomPortletMode(ExoXPPParser xpp) throws Exception {
        CustomPortletMode mode = new CustomPortletMode();
        mode.setId(xpp.getNodeAttributeValue("id"));
        while (xpp.node("description")) {
            mode.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("portlet-mode");
        mode.setPortletMode(xpp.getContent().trim());
        if (xpp.node("portal-managed")) {
            mode.setPortalManaged(new Boolean(xpp.getContent().trim()));
        } else {
            mode.setPortalManaged(Boolean.TRUE);
        }
        return mode;
    }

    public static CustomWindowState readCustomWindowState(ExoXPPParser xpp) throws Exception {
        CustomWindowState state = new CustomWindowState();
        state.setId(xpp.getNodeAttributeValue("id"));
        while (xpp.node("description")) {
            state.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("window-state");
        state.setWindowState(xpp.getContent().trim());
        if (!newSpec) {
            List<Portlet> portlets = portletapp.getPortlet();
            for (int i = 0; i < portlets.toArray().length; ++i) {
                Portlet portlet = (Portlet)portlets.toArray()[i];
                List<Supports> supports = portlet.getSupports();
                for (int j = 0; j < supports.toArray().length; ++j) {
                    Supports support = (Supports)supports.toArray()[j];
                    support.addWindowState(state.getWindowState());
                }
            }
        }
        return state;
    }

    public static UserAttribute readUserAttribute(ExoXPPParser xpp) throws Exception {
        UserAttribute att = new UserAttribute();
        att.setId(xpp.getNodeAttributeValue("id"));
        while (xpp.node("description")) {
            att.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("name");
        att.setName(xpp.getContent().trim());
        return att;
    }

    public static SecurityConstraint readSecurityConstraint(ExoXPPParser xpp) throws Exception {
        SecurityConstraint sc = new SecurityConstraint();
        sc.setId(xpp.getNodeAttributeValue("id"));
        if (xpp.node("displayName")) {
            sc.addDisplayName(XMLParser.readDisplayName(xpp));
        }
        if (xpp.node("display-name")) {
            sc.addDisplayName(XMLParser.readDisplayName(xpp));
        }
        xpp.mandatoryNode("portlet-collection");
        sc.setPortletCollection(XMLParser.readPortletCollection(xpp));
        xpp.mandatoryNode("user-data-constraint");
        sc.setUserDataConstraint(XMLParser.readUserDataConstraint(xpp));
        return sc;
    }

    public static Description readDescription(ExoXPPParser xpp) throws Exception {
        Description desc = new Description();
        desc.setLang(xpp.getNodeAttributeValue("xml:lang"));
        desc.setDescription(xpp.getContent().trim());
        return desc;
    }

    public static DisplayName readDisplayName(ExoXPPParser xpp) throws Exception {
        DisplayName name = new DisplayName();
        name.setLang(xpp.getNodeAttributeValue("xml:lang"));
        name.setDisplayName(xpp.getContent().trim());
        return name;
    }

    public static InitParam readInitParam(ExoXPPParser xpp) throws Exception {
        InitParam param = new InitParam();
        while (xpp.node("description")) {
            param.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("name");
        param.setName(xpp.getContent().trim());
        xpp.mandatoryNode("value");
        param.setValue(xpp.getContent());
        return param;
    }

    public static Supports readSupports(ExoXPPParser xpp) throws Exception {
        Supports supports = new Supports();
        supports.setId(xpp.getNodeAttributeValue("id"));
        xpp.mandatoryNode("mime-type");
        supports.setMimeType(xpp.getContent().trim());
        ArrayList<String> portletMode = new ArrayList<String>();
        while (xpp.node("portlet-mode")) {
            portletMode.add(xpp.getContent().trim().toLowerCase());
        }
        if (!portletMode.contains(PortletMode.VIEW.toString().toLowerCase())) {
            portletMode.add(PortletMode.VIEW.toString().toLowerCase());
        }
        Iterator iterModes = portletMode.iterator();
        while (iterModes.hasNext()) {
            supports.addPortletMode((String)iterModes.next());
        }
        if (newSpec) {
            ArrayList<String> windowState = new ArrayList<String>();
            while (xpp.node("window-state")) {
                windowState.add(xpp.getContent().trim());
            }
            if (!windowState.contains(WindowState.MINIMIZED.toString())) {
                supports.addWindowState(WindowState.MINIMIZED.toString());
            }
            if (!windowState.contains(WindowState.NORMAL.toString())) {
                supports.addWindowState(WindowState.NORMAL.toString());
            }
            if (!windowState.contains(WindowState.MAXIMIZED.toString())) {
                supports.addWindowState(WindowState.MAXIMIZED.toString());
            }
            Iterator iterStates = windowState.iterator();
            while (iterStates.hasNext()) {
                supports.addWindowState((String)iterStates.next());
            }
        } else {
            supports.addWindowState(WindowState.MINIMIZED.toString());
            supports.addWindowState(WindowState.NORMAL.toString());
            supports.addWindowState(WindowState.MAXIMIZED.toString());
        }
        return supports;
    }

    public static PortletInfo readPortletInfo(ExoXPPParser xpp) throws Exception {
        PortletInfo info = new PortletInfo();
        if (xpp.node("title")) {
            info.setTitle(xpp.getContent());
        }
        if (xpp.node("short-title")) {
            info.setShortTitle(xpp.getContent());
        }
        if (xpp.node("keywords")) {
            info.setKeywords(xpp.getContent());
        }
        return info;
    }

    public static ExoPortletPreferences readPortletPreferences(ExoXPPParser xpp) throws Exception {
        ExoPortletPreferences prefs = new ExoPortletPreferences();
        prefs.setId(xpp.getNodeAttributeValue("id"));
        while (xpp.node("preference")) {
            prefs.addPreference(XMLParser.readPreference(xpp));
        }
        if (xpp.node("preferences-validator")) {
            prefs.setPreferencesValidator(xpp.getContent().trim());
        }
        return prefs;
    }

    public static Preference readPreference(ExoXPPParser xpp) throws Exception {
        Preference pref = new Preference();
        pref.setId(xpp.getNodeAttributeValue("id"));
        xpp.mandatoryNode("name");
        pref.setName(xpp.getContent().trim());
        while (xpp.node("value")) {
            pref.addValue(xpp.getContent());
        }
        if (xpp.node("read-only")) {
            pref.setReadOnly(xpp.getContent().trim());
        }
        return pref;
    }

    public static SecurityRoleRef readSecurityRoleRef(ExoXPPParser xpp) throws Exception {
        SecurityRoleRef ref = new SecurityRoleRef();
        ref.setId(xpp.getNodeAttributeValue("id"));
        while (xpp.node("description")) {
            ref.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("role-name");
        ref.setRoleName(xpp.getContent().trim());
        if (xpp.node("role-link")) {
            ref.setRoleLink(xpp.getContent().trim());
        }
        return ref;
    }

    public static Filter readFilter(ExoXPPParser xpp) throws Exception {
        Filter filter = new Filter();
        while (xpp.node("description")) {
            filter.addDescription(XMLParser.readDescription(xpp));
        }
        while (xpp.node("display-name")) {
            filter.addDisplayName(XMLParser.readDisplayName(xpp));
        }
        xpp.mandatoryNode("filter-name");
        filter.setFilterName(xpp.getContent().trim());
        xpp.mandatoryNode("filter-class");
        filter.setFilterClass(xpp.getContent().trim());
        xpp.mandatoryNode("lifecycle");
        filter.addLifecycle(XMLParser.parseLifecycle(xpp.getContent().trim(), filter.getFilterName()));
        while (xpp.node("lifecycle")) {
            filter.addLifecycle(XMLParser.parseLifecycle(xpp.getContent().trim(), filter.getFilterName()));
        }
        if (filter.getLifecycle() == Constants.EMPTY_LIST) {
            filter.addLifecycle(0);
        }
        while (xpp.node("init-param")) {
            filter.addInitParam(XMLParser.readInitParam(xpp));
        }
        return filter;
    }

    public static Integer parseLifecycle(String cycle, String filterName) {
        if (cycle.equalsIgnoreCase("ACTION_PHASE")) {
            return 1;
        }
        if (cycle.equalsIgnoreCase("EVENT_PHASE")) {
            return 2;
        }
        if (cycle.equalsIgnoreCase("RENDER_PHASE")) {
            return 3;
        }
        if (cycle.equalsIgnoreCase("RESOURCE_PHASE")) {
            return 4;
        }
        Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
        log.error((Object)("WHILE PARSING portlet.xml the filter '" + filterName + "' doesn't have proper lifecycle."));
        return null;
    }

    public static FilterMapping readFilterMapping(ExoXPPParser xpp) throws Exception {
        FilterMapping filterMapping = new FilterMapping();
        xpp.mandatoryNode("filter-name");
        filterMapping.setFilterName(xpp.getContent().trim());
        xpp.mandatoryNode("portlet-name");
        filterMapping.addPortletName(xpp.getContent().trim());
        while (xpp.node("portlet-name")) {
            filterMapping.addPortletName(xpp.getContent().trim());
        }
        return filterMapping;
    }

    public static PortletCollection readPortletCollection(ExoXPPParser xpp) throws Exception {
        PortletCollection collection = new PortletCollection();
        xpp.mandatoryNode("portlet-name");
        collection.addPortletName(xpp.getContent().trim());
        while (xpp.node("portlet-name")) {
            collection.addPortletName(xpp.getContent().trim());
        }
        return collection;
    }

    public static UserDataConstraint readUserDataConstraint(ExoXPPParser xpp) throws Exception {
        UserDataConstraint u = new UserDataConstraint();
        u.setId(xpp.getNodeAttributeValue("id"));
        while (xpp.node("description")) {
            u.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("transport-guarantee");
        u.setTransportGuarantie(xpp.getContent().trim());
        return u;
    }

    private static QName parseQName(ExoXPPParser xpp) throws Exception {
        String cnt = xpp.getContent().trim();
        try {
            int cm = cnt.indexOf(58);
            if (cm == -1) {
                return new QName(cnt);
            }
            String ns = cnt.substring(0, cm);
            cnt = cnt.substring(cm + 1);
            ns = xpp.getNodeAttributeValue("xmlns:" + ns);
            return new QName(ns, cnt);
        }
        catch (NullPointerException e) {
            return new QName(cnt);
        }
        catch (StringIndexOutOfBoundsException e) {
            return new QName(cnt);
        }
    }

    public static EventDefinition readEventDefinition(ExoXPPParser xpp) throws Exception {
        EventDefinition ed = new EventDefinition();
        ed.setId(xpp.getNodeAttributeValue("id"));
        while (xpp.node("description")) {
            ed.addDescription(XMLParser.readDescription(xpp));
        }
        if (xpp.node("qname")) {
            ed.setPrefferedName(XMLParser.parseQName(xpp));
        } else {
            xpp.mandatoryNode("name");
            ed.setPrefferedName(new QName(xpp.getContent().trim()));
        }
        while (xpp.node("alias")) {
            ed.addAlias(new QName(xpp.getContent().trim()));
        }
        if (xpp.node("value-type")) {
            ed.setJavaClass(xpp.getContent().trim());
        }
        return ed;
    }

    public static QName readEventReference(ExoXPPParser xpp) throws Exception {
        QName name;
        if (xpp.node("qname")) {
            name = XMLParser.parseQName(xpp);
        } else {
            xpp.mandatoryNode("name");
            name = new QName(xpp.getContent().trim());
        }
        return name;
    }

    public static String readUrlListener(ExoXPPParser xpp) throws Exception {
        while (xpp.node("description")) {
            XMLParser.readDescription(xpp);
        }
        while (xpp.node("display-name")) {
            XMLParser.readDisplayName(xpp);
        }
        xpp.mandatoryNode("listener-class");
        return xpp.getContent().trim();
    }

    public static void fillPredefinedEvents(PortletApp app) throws Exception {
        EventDefinition ed = new EventDefinition();
        ed.setPrefferedName(new QName("urn:oasis:names:tc:wsrp:v2:types", "wsrp:eventHandlingFailed"));
        app.addEventDefinition(ed);
        ed = new EventDefinition();
        ed.setPrefferedName(new QName("urn:oasis:names:tc:wsrp:v2:types", "wsrp:newNavigationalContextScope"));
        app.addEventDefinition(ed);
    }

    public static PublicRenderParameter readPublicRenderParameter(ExoXPPParser xpp) throws Exception {
        PublicRenderParameter srp = new PublicRenderParameter();
        srp.setId(xpp.getNodeAttributeValue("id"));
        while (xpp.node("description")) {
            srp.addDescription(xpp.getContent().trim());
        }
        xpp.mandatoryNode("identifier");
        srp.setIdentifier(xpp.getContent().trim());
        if (xpp.node("qname")) {
            srp.setQname(XMLParser.parseQName(xpp));
        } else {
            xpp.mandatoryNode("name");
        }
        srp.setName(xpp.getContent().trim());
        while (xpp.node("alias")) {
            srp.addAlias(XMLParser.parseQName(xpp));
        }
        return srp;
    }

    public static Map<String, String[]> readContainerRuntimeOption(ExoXPPParser xpp) throws Exception {
        HashMap<String, String[]> options = new HashMap<String, String[]>();
        xpp.mandatoryNode("name");
        String name = xpp.getContent().trim();
        ArrayList<String> values = new ArrayList<String>();
        if (xpp.node("value")) {
            values.add(xpp.getContent().trim());
        } else {
            options.put(name, null);
            return options;
        }
        while (xpp.node("value")) {
            values.add(xpp.getContent().trim());
        }
        options.put(name, (String[])values.toArray());
        return options;
    }
}

