/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.web.application.javascript.JavascriptConfigService;

public class JavascriptManager {
    private StringBuilder javascript = new StringBuilder(1000);
    private StringBuilder customizedOnloadJavascript;
    private JavascriptConfigService jsSrevice_ = (JavascriptConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(JavascriptConfigService.class);

    public void addJavascript(CharSequence s) {
        this.javascript.append(s).append(" \n");
    }

    public void importJavascript(CharSequence s) {
        if (!this.jsSrevice_.isModuleLoaded(s) || "true".equals(System.getProperty("exo.product.developing"))) {
            this.javascript.append("eXo.require('").append(s).append("'); \n");
        }
    }

    public void importJavascript(String s, String location) {
        if (!location.endsWith("/")) {
            location = location + '/';
        }
        if (!this.jsSrevice_.isModuleLoaded(s) || "true".equals(System.getProperty("exo.product.developing"))) {
            this.javascript.append("eXo.require('").append(s).append("', '").append(location).append("'); \n");
        }
    }

    public void addOnLoadJavascript(CharSequence s) {
        String id = Integer.toString(Math.abs(s.hashCode()));
        this.javascript.append("eXo.core.Browser.addOnLoadCallback('mid").append(id).append("',").append(s).append("); \n");
    }

    public void addOnResizeJavascript(CharSequence s) {
        String id = Integer.toString(Math.abs(s.hashCode()));
        this.javascript.append("eXo.core.Browser.addOnResizeCallback('mid").append(id).append("',").append(s).append("); \n");
    }

    public void addOnScrollJavascript(CharSequence s) {
        String id = Integer.toString(Math.abs(s.hashCode()));
        this.javascript.append("eXo.core.Browser.addOnScrollCallback('mid").append(id).append("',").append(s).append("); \n");
    }

    public String getJavascript() {
        return this.javascript.toString();
    }

    public void addCustomizedOnLoadScript(CharSequence s) {
        if (this.customizedOnloadJavascript == null) {
            this.customizedOnloadJavascript = new StringBuilder();
        }
        this.customizedOnloadJavascript.append(s).append("\n");
    }

    public String getCustomizedOnLoadScript() {
        if (this.customizedOnloadJavascript == null) {
            return "";
        }
        return this.customizedOnloadJavascript.toString();
    }
}

