/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.StateManager;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebuiRequestContext
extends RequestContext {
    protected UIApplication uiApplication_;
    protected String sessionId_;
    protected ResourceBundle appRes_;
    private StateManager stateManager_;
    private boolean responseComplete_ = false;
    private boolean processRender_ = false;
    private Throwable executionError_;
    private ArrayList<UIComponent> uicomponentToUpdateByAjax;

    public WebuiRequestContext(Application app) {
        super(app);
    }

    public String getSessionId() {
        return this.sessionId_;
    }

    protected void setSessionId(String id) {
        this.sessionId_ = id;
    }

    public UIApplication getUIApplication() {
        return this.uiApplication_;
    }

    public void setUIApplication(UIApplication uiApplication) throws Exception {
        this.uiApplication_ = uiApplication;
        this.appRes_ = this.getApplication().getResourceBundle(uiApplication.getLocale());
    }

    public void refreshResourceBundle() throws Exception {
        this.appRes_ = this.getApplication().getResourceBundle(this.uiApplication_.getLocale());
    }

    public Locale getLocale() {
        return this.uiApplication_.getLocale();
    }

    public ResourceBundle getApplicationResourceBundle() {
        return this.appRes_;
    }

    public String getActionParameterName() {
        return "op";
    }

    public String getUIComponentIdParameterName() {
        return "uicomponent";
    }

    public abstract String getRequestContextPath();

    public abstract <T> T getRequest() throws Exception;

    public abstract <T> T getResponse() throws Exception;

    public Throwable getExecutionError() {
        return this.executionError_;
    }

    public boolean isResponseComplete() {
        return this.responseComplete_;
    }

    public void setResponseComplete(boolean b) {
        this.responseComplete_ = b;
    }

    public boolean getProcessRender() {
        return this.processRender_;
    }

    public void setProcessRender(boolean b) {
        this.processRender_ = b;
    }

    public List<UIComponent> getUIComponentToUpdateByAjax() {
        return this.uicomponentToUpdateByAjax;
    }

    public void addUIComponentToUpdateByAjax(UIComponent uicomponent) {
        if (this.uicomponentToUpdateByAjax == null) {
            this.uicomponentToUpdateByAjax = new ArrayList();
        }
        this.uicomponentToUpdateByAjax.add(uicomponent);
    }

    public ResourceResolver getResourceResolver(String uri) {
        Application app = this.getApplication();
        while (app != null) {
            ApplicationResourceResolver appResolver = app.getResourceResolver();
            ResourceResolver resolver = appResolver.getResourceResolver(uri);
            if (resolver != null) {
                return resolver;
            }
            RequestContext pcontext = this.getParentAppRequestContext();
            if (pcontext != null) {
                app = pcontext.getApplication();
                continue;
            }
            app = null;
        }
        return null;
    }

    public StateManager getStateManager() {
        return this.stateManager_;
    }

    public void setStateManager(StateManager manager) {
        this.stateManager_ = manager;
    }
}

