/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.util.List;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, name="CloseFormPopup", phase=Event.Phase.DECODE)})
public class UIFormPopupWindow
extends UIPopupWindow
implements UIFormInput<Object> {
    public UIFormPopupWindow() {
        this.closeEvent_ = "CloseFormPopup";
    }

    @Override
    public void processDecode(WebuiRequestContext context) throws Exception {
        UIForm uiForm = this.getAncestorOfType(UIForm.class);
        String action = uiForm.getSubmitAction();
        if (action == null) {
            return;
        }
        Event<UIComponent> event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event != null) {
            event.broadcast();
        }
        this.getUIComponent().processDecode(context);
        if (this.getUIComponent() == null) {
            return;
        }
    }

    @Override
    public String event(String name) throws Exception {
        UIForm uiForm = this.getAncestorOfType(UIForm.class);
        if (uiForm != null) {
            return uiForm.event(name, this.getId(), (String)null);
        }
        return super.event(name);
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public <E extends Validator> UIFormInput addValidator(Class<E> clazz, Object ... params) throws Exception {
        return this;
    }

    @Override
    public String getBindingField() {
        return null;
    }

    @Override
    public List getValidators() {
        return null;
    }

    @Override
    public Object getValue() throws Exception {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public Class getTypeValue() {
        return null;
    }

    @Override
    public UIFormInput setValue(Object value) throws Exception {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPopupWindow> {
        @Override
        public void execute(Event<UIPopupWindow> event) throws Exception {
            UIPopupWindow uiPopupWindow = event.getSource();
            UIForm uiForm = uiPopupWindow.getAncestorOfType(UIForm.class);
            uiPopupWindow.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm.getParent());
        }
    }
}

