/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class StringLengthValidator
implements Validator {
    private Integer min_ = 0;
    private Integer max_ = 0;

    public StringLengthValidator(Integer max) {
        this.max_ = max;
    }

    public StringLengthValidator(Integer min, Integer max) {
        this.min_ = min;
        this.max_ = max;
    }

    public void validate(UIFormInput uiInput) throws Exception {
        UIComponent uiComponent;
        UIForm uiForm;
        String label;
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        if (uiInput.getValue() != null) {
            int length = ((String)uiInput.getValue()).trim().length();
            if (this.min_ <= length && this.max_ >= length) {
                return;
            }
        }
        if ((label = (uiForm = (uiComponent = (UIComponent)((Object)uiInput)).getAncestorOfType(UIForm.class)).getLabel(uiInput.getName())) == null) {
            label = uiInput.getName();
        }
        if ((label = label.trim()).charAt(label.length() - 1) == ':') {
            label = label.substring(0, label.length() - 1);
        }
        Object[] args = new Object[]{label, this.min_.toString(), this.max_.toString()};
        throw new MessageException(new ApplicationMessage("StringLengthValidator.msg.length-invalid", args, 1));
    }
}

