/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import java.util.List;
import org.exoplatform.portal.application.UserWidgetStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Widgets;
import org.exoplatform.portal.webui.application.UIAddNewApplication;
import org.exoplatform.portal.webui.application.UIWidget;
import org.exoplatform.portal.webui.application.UIWidgets;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.container.UIContainerForm;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIContainerActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowAddNewApplicationActionListener
    extends EventListener<UIContainer> {
        public void execute(Event<UIContainer> event) throws Exception {
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIAddNewApplication uiAddApplication = (UIAddNewApplication)uiPortal.createUIComponent(UIAddNewApplication.class, null, null);
            String[] applicationTypes = new String[]{"eXoWidget"};
            uiAddApplication.setInPage(false);
            uiAddApplication.setUiComponentParent((UIComponent)event.getSource());
            uiAddApplication.getApplicationCategories(event.getRequestContext().getRemoteUser(), applicationTypes);
            uiMaskWorkspace.setWindowSize(700, 375);
            uiMaskWorkspace.setUIComponent((UIComponent)uiAddApplication);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteWidgetActionListener
    extends EventListener<UIContainer> {
        public void execute(Event<UIContainer> event) throws Exception {
            WebuiRequestContext pContext = event.getRequestContext();
            String id = pContext.getRequestParameter("objectId");
            UIContainer uiWidgetContainer = (UIContainer)((Object)event.getSource());
            List children = uiWidgetContainer.getChildren();
            for (UIComponent uiChild : children) {
                UIWidget uiWidget = (UIWidget)uiChild;
                if (!uiWidget.getApplicationInstanceUniqueId().equals(id)) continue;
                children.remove((Object)uiWidget);
                String userName = pContext.getRemoteUser();
                if (userName == null || userName.trim().length() <= 0) break;
                UserWidgetStorage widgetDataService = (UserWidgetStorage)uiWidgetContainer.getApplicationComponent(UserWidgetStorage.class);
                widgetDataService.delete(userName, uiWidget.getApplicationName(), uiWidget.getApplicationInstanceUniqueId());
                break;
            }
            UIWidgets uiWidgets = (UIWidgets)uiWidgetContainer.getAncestorOfType(UIWidgets.class);
            Widgets widgets = PortalDataMapper.toWidgets(uiWidgets);
            UserPortalConfigService configService = (UserPortalConfigService)uiWidgetContainer.getApplicationComponent(UserPortalConfigService.class);
            configService.update(widgets);
            UIPortalApplication uiPortalApp = (UIPortalApplication)event.getRequestContext().getUIApplication();
            uiPortalApp.getUserPortalConfig().setWidgets(widgets);
            pContext.setResponseComplete(true);
            pContext.getWriter().write("OK");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditContainerActionListener
    extends EventListener<UIContainer> {
        public void execute(Event<UIContainer> event) throws Exception {
            UIContainer uiContainer = (UIContainer)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIContainerForm containerForm = uiMaskWS.createUIComponent(UIContainerForm.class, null, null);
            if (uiContainer.getId().equals(id)) {
                containerForm.setValues(uiContainer);
            } else if (uiContainer.getChildById(id) != null) {
                containerForm.setValues((UIContainer)uiContainer.getChildById(id));
            } else {
                return;
            }
            uiMaskWS.setUIComponent((UIComponent)containerForm);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            Util.updateUIApplication(event);
        }
    }
}

