/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.tidy;

import org.exoplatform.services.chars.CharsUtil;
import org.exoplatform.services.chars.SpecChar;
import org.exoplatform.services.html.Name;
import org.exoplatform.services.html.parser.HTML;
import org.exoplatform.services.html.parser.NodeImpl;
import org.exoplatform.services.token.TokenParser;
import org.exoplatform.services.token.TypeToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TidyToken
extends TokenParser.Factory<NodeImpl> {
    private char[] script = new char[]{'s', 'c', 'r', 'i', 'p', 't'};
    private char[] style = new char[]{'s', 't', 'y', 'l', 'e'};
    private TokenParser parser;

    @Override
    public int create(char[] data, int start, int end, int type) {
        if (start >= end) {
            return end;
        }
        if (start > data.length) {
            return data.length;
        }
        char[] value = CharsUtil.cutAndTrim(data, start, Math.min(end, data.length));
        if (value.length < 1) {
            return end;
        }
        if (type != TypeToken.TAG) {
            Name name = type == TypeToken.COMMENT ? Name.COMMENT : Name.CONTENT;
            this.push(new NodeImpl(value, name));
            return end;
        }
        if (value[0] == SpecChar.END_TAG) {
            if (value.length <= 1) {
                return end;
            }
            Name name = HTML.getName(new String(value = CharsUtil.cutAndTrim(value, 1, value.length)).toUpperCase());
            if (name == null) {
                char[] newValue = new char[value.length + 1];
                newValue[0] = SpecChar.END_TAG;
                System.arraycopy(value, 0, newValue, 1, value.length);
                this.push(new NodeImpl(newValue, Name.UNKNOWN));
                return end;
            }
            this.push(new NodeImpl(value, name, TypeToken.CLOSE));
            return end;
        }
        String nameValue = new String(CharsUtil.cutBySpace(value, 0)).toUpperCase();
        if (nameValue.charAt(nameValue.length() - 1) == SpecChar.END_TAG) {
            nameValue = nameValue.substring(0, nameValue.length() - 1).trim();
        }
        if (nameValue.equals("!DOCTYPE")) {
            return end;
        }
        Name name = HTML.getName(nameValue);
        if (name == null) {
            this.push(new NodeImpl(value, Name.UNKNOWN));
            return end;
        }
        this.push(new NodeImpl(value, name, TypeToken.TAG));
        if (name == Name.SCRIPT) {
            return this.findEndScript(data, this.script, end);
        }
        if (name == Name.STYLE) {
            return this.findEndScript(data, this.style, end);
        }
        return end;
    }

    private int findEndScript(char[] value, char[] c, int start) {
        int[] idx = this.indexEndNode(value, c, start);
        if (idx.length < 1) {
            return start;
        }
        this.create(value, start + 1, idx[0], TypeToken.CONTENT);
        return this.create(value, idx[1], idx[2], TypeToken.TAG);
    }

    private int[] indexEndNode(char[] value, char[] c, int start) {
        boolean is = false;
        int[] idx = new int[3];
        for (int i = start; i < value.length; ++i) {
            if (value[i] != SpecChar.OPEN_TAG) continue;
            is = true;
            idx[0] = i;
            int k = i + 1;
            if (value[k] == SpecChar.PUNCTUATION_MASK && this.parser.isComment(value, k)) {
                int startComment = k;
                int endComment = this.parser.findEndComment(value, k);
                if ((startComment = this.create(value, startComment - 1, endComment, TypeToken.COMMENT)) >= value.length || value[startComment] != SpecChar.OPEN_TAG) break;
                i = startComment + 1;
                continue;
            }
            while (k < value.length) {
                if (value[k] == SpecChar.END_TAG) {
                    idx[1] = k;
                }
                if (value[k] != SpecChar.END_TAG && !Character.isWhitespace(value[k])) break;
                ++k;
            }
            for (int j = 0; j < c.length; ++j) {
                if (c[j] == Character.toLowerCase(value[k + j])) continue;
                if (k + j == value.length - 1) {
                    is = false;
                    break;
                }
                is = false;
                break;
            }
            if (!is) continue;
            k += c.length;
            while (k < value.length && (value[k] == SpecChar.END_TAG || Character.isWhitespace(value[k]))) {
                ++k;
            }
            if (k >= value.length) {
                return new int[0];
            }
            idx[2] = k;
            if (value[k] != SpecChar.CLOSE_TAG) continue;
            return idx;
        }
        return new int[0];
    }

    public TokenParser getParser() {
        return this.parser;
    }

    public void setParser(TokenParser parser) {
        this.parser = parser;
    }
}

