/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import org.exoplatform.services.jcr.webdav.WebDavStatus;
import org.exoplatform.services.jcr.webdav.resource.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropstatGroupedRepresentation {
    protected final Map<String, Set<HierarchicalProperty>> propStats;
    protected Set<QName> propNames = null;
    protected final boolean namesOnly;
    protected final Resource resource;

    public PropstatGroupedRepresentation(Resource resource, Set<QName> propNames, boolean namesOnly) throws RepositoryException {
        this.namesOnly = namesOnly;
        this.resource = resource;
        this.propStats = new HashMap<String, Set<HierarchicalProperty>>();
        this.propNames = propNames;
        if (propNames != null) {
            this.propNames = new HashSet<QName>();
            for (QName property : propNames) {
                this.propNames.add(property);
            }
        }
    }

    public final Map<String, Set<HierarchicalProperty>> getPropStats() throws RepositoryException {
        String statname = WebDavStatus.getStatusDescription(200);
        if (this.propNames == null) {
            this.propStats.put(statname, this.resource.getProperties(this.namesOnly));
        } else {
            for (QName propName : this.propNames) {
                HierarchicalProperty prop = new HierarchicalProperty(propName);
                try {
                    prop = this.resource.getProperty(propName);
                    statname = WebDavStatus.getStatusDescription(200);
                }
                catch (AccessDeniedException e) {
                    statname = WebDavStatus.getStatusDescription(403);
                    e.printStackTrace();
                }
                catch (ItemNotFoundException e) {
                    statname = WebDavStatus.getStatusDescription(404);
                    e.printStackTrace();
                }
                catch (PathNotFoundException e) {
                    statname = WebDavStatus.getStatusDescription(404);
                }
                catch (RepositoryException e) {
                    statname = WebDavStatus.getStatusDescription(500);
                }
                if (!this.propStats.containsKey(statname)) {
                    this.propStats.put(statname, new HashSet());
                }
                Set<HierarchicalProperty> propSet = this.propStats.get(statname);
                propSet.add(prop);
            }
        }
        return this.propStats;
    }
}

