/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.XASessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.impl.CredentialsImpl;
import org.exoplatform.services.transaction.TransactionService;

public class SessionFactory {
    protected static Log log = ExoLogger.getLogger((String)"jcr.SessionFactory");
    private OrganizationService organizationService;
    private ExoContainer container;
    private TransactionService tService;
    private String workspaceName;
    private TransactionableResourceManager txResourceManager = null;

    public SessionFactory(OrganizationService orgService, TransactionService tService, WorkspaceEntry config, ExoContainerContext containerContext) {
        this.organizationService = orgService;
        this.container = containerContext.getContainer();
        this.workspaceName = config.getName();
        this.tService = tService;
        this.txResourceManager = new TransactionableResourceManager();
    }

    public SessionFactory(OrganizationService orgService, WorkspaceEntry config, ExoContainerContext containerContext) {
        this(orgService, null, config, containerContext);
    }

    SessionImpl createSession(CredentialsImpl credentials) throws RepositoryException {
        if (this.tService == null) {
            return new SessionImpl(this.workspaceName, (Credentials)credentials, this.container);
        }
        XASessionImpl xaSession = new XASessionImpl(this.workspaceName, (Credentials)credentials, this.container, this.tService, this.txResourceManager);
        try {
            xaSession.enlistResource();
        }
        catch (XAException e) {
            throw new RepositoryException((Throwable)e);
        }
        return xaSession;
    }
}

