/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.log.ExoLogger;

class NodeIteratorImpl
implements ScoreNodeIterator {
    private static Log log = ExoLogger.getLogger((String)"jcr.NodeIteratorImpl");
    protected final String[] identifiers;
    protected final Float[] scores;
    protected final SessionDataManager itemMgr;
    protected int pos = -1;
    protected int invalid = 0;
    private NodeImpl next;

    NodeIteratorImpl(SessionDataManager itemMgr, String[] identifiers, Float[] scores) {
        this.itemMgr = itemMgr;
        this.identifiers = identifiers;
        this.scores = scores;
        this.fetchNext();
    }

    public Node nextNode() throws NoSuchElementException {
        return this.nextNodeImpl();
    }

    public Object next() throws NoSuchElementException {
        return this.nextNode();
    }

    public NodeImpl nextNodeImpl() throws NoSuchElementException {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        NodeImpl n = this.next;
        this.fetchNext();
        return n;
    }

    public void skip(long skipNum) throws NoSuchElementException {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        if ((long)this.pos + skipNum > (long)this.identifiers.length) {
            throw new NoSuchElementException();
        }
        if (skipNum != 0L) {
            this.pos = (int)((long)this.pos + (skipNum - 1L));
            this.fetchNext();
        }
    }

    public long getSize() {
        return this.identifiers.length - this.invalid;
    }

    public long getPosition() {
        return this.pos - this.invalid;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public float getScore() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.scores[this.pos].floatValue();
    }

    protected void fetchNext() {
        this.next = null;
        while (this.next == null && this.pos + 1 < this.identifiers.length) {
            try {
                this.next = (NodeImpl)this.itemMgr.getItemByIdentifier(this.identifiers[this.pos + 1], true);
            }
            catch (RepositoryException e) {
                log.warn((Object)("Exception retrieving Node with UUID: " + this.identifiers[this.pos + 1] + ": " + e.toString()));
                ++this.invalid;
            }
            ++this.pos;
        }
        if (this.identifiers.length == 0) {
            this.pos = this.identifiers.length;
        } else if (this.pos + 1 == this.identifiers.length && this.next == null) {
            ++this.pos;
        }
    }
}

