/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.xpath;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DerefQueryNode;
import org.exoplatform.services.jcr.impl.core.query.ExactQueryNode;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NotQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryConstants;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TextsearchQueryNode;
import org.exoplatform.services.jcr.impl.core.query.xpath.XPathQueryBuilder;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;

class QueryFormat
implements QueryNodeVisitor,
QueryConstants {
    private final LocationFactory locationFactory;
    private String statement;
    private List exceptions = new ArrayList();

    private QueryFormat(QueryRootNode root, LocationFactory locationFactory) throws InvalidQueryException {
        this.locationFactory = locationFactory;
        this.statement = root.accept(this, new StringBuffer()).toString();
        if (this.exceptions.size() > 0) {
            Exception e = (Exception)this.exceptions.get(0);
            throw new InvalidQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public static String toString(QueryRootNode root, LocationFactory locationFactory) throws InvalidQueryException {
        return new QueryFormat(root, locationFactory).toString();
    }

    public String toString() {
        return this.statement;
    }

    public Object visit(QueryRootNode node, Object data) {
        InternalQName[] selectProps;
        StringBuffer sb = (StringBuffer)data;
        node.getLocationNode().accept(this, data);
        if (node.getOrderNode() != null) {
            node.getOrderNode().accept(this, data);
        }
        if ((selectProps = node.getSelectProperties()).length > 0) {
            boolean union;
            sb.append('/');
            boolean bl = union = selectProps.length > 1;
            if (union) {
                sb.append('(');
            }
            String pipe = "";
            for (int i = 0; i < selectProps.length; ++i) {
                try {
                    sb.append(pipe);
                    sb.append('@');
                    sb.append(ISO9075.encode(this.jcrName(selectProps[i])));
                    pipe = "|";
                    continue;
                }
                catch (RepositoryException e) {
                    this.exceptions.add(e);
                }
            }
            if (union) {
                sb.append(')');
            }
        }
        return data;
    }

    public Object visit(OrQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        boolean bracket = false;
        if (node.getParent() instanceof AndQueryNode) {
            bracket = true;
        }
        if (bracket) {
            sb.append("(");
        }
        String or = "";
        QueryNode[] operands = node.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            sb.append(or);
            operands[i].accept(this, sb);
            or = " or ";
        }
        if (bracket) {
            sb.append(")");
        }
        return sb;
    }

    public Object visit(AndQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        String and = "";
        QueryNode[] operands = node.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            sb.append(and);
            operands[i].accept(this, sb);
            and = " and ";
        }
        return sb;
    }

    public Object visit(NotQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        QueryNode[] operands = node.getOperands();
        if (operands.length > 0) {
            try {
                sb.append(this.jcrName(XPathQueryBuilder.FN_NOT_10));
                sb.append("(");
                operands[0].accept(this, sb);
                sb.append(")");
            }
            catch (RepositoryException e) {
                this.exceptions.add(e);
            }
        }
        return sb;
    }

    public Object visit(ExactQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        sb.append("@");
        try {
            sb.append(ISO9075.encode(this.jcrName(node.getPropertyName())));
            sb.append("='").append(this.jcrName(node.getValue()));
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        sb.append("'");
        return sb;
    }

    public Object visit(NodeTypeQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            sb.append("@");
            sb.append(this.jcrName(Constants.JCR_PRIMARYTYPE));
            sb.append("='").append(this.jcrName(node.getValue()));
            sb.append("'");
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        return sb;
    }

    public Object visit(TextsearchQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            sb.append(this.jcrName(XPathQueryBuilder.JCR_CONTAINS));
            sb.append("(");
            if (node.getPropertyName() == null) {
                sb.append(".");
            } else {
                sb.append(ISO9075.encode(this.jcrName(node.getPropertyName())));
            }
            sb.append(", '");
            sb.append(node.getQuery().replaceAll("'", "''"));
            sb.append("')");
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        return sb;
    }

    public Object visit(PathQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        if (node.isAbsolute()) {
            sb.append("/");
        }
        LocationStepQueryNode[] steps = node.getPathSteps();
        String slash = "";
        for (int i = 0; i < steps.length; ++i) {
            sb.append(slash);
            steps[i].accept(this, sb);
            slash = "/";
        }
        return sb;
    }

    public Object visit(LocationStepQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        if (node.getIncludeDescendants()) {
            sb.append('/');
        }
        if (node.getNameTest() == null) {
            sb.append("*");
        } else {
            try {
                if (node.getNameTest().getName().length() == 0) {
                    sb.append(this.jcrName(XPathQueryBuilder.JCR_ROOT));
                } else {
                    sb.append(ISO9075.encode(this.jcrName(node.getNameTest())));
                }
            }
            catch (RepositoryException e) {
                this.exceptions.add(e);
            }
        }
        if (node.getIndex() != -2147483647) {
            sb.append('[').append(node.getIndex()).append(']');
        }
        QueryNode[] predicates = node.getPredicates();
        for (int i = 0; i < predicates.length; ++i) {
            sb.append('[');
            predicates[i].accept(this, sb);
            sb.append(']');
        }
        return sb;
    }

    public Object visit(DerefQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            sb.append(this.jcrName(XPathQueryBuilder.JCR_DEREF));
            sb.append("(@");
            sb.append(ISO9075.encode(this.jcrName(node.getRefProperty())));
            sb.append(", '");
            if (node.getNameTest() == null) {
                sb.append("*");
            } else {
                sb.append(ISO9075.encode(this.jcrName(node.getNameTest())));
            }
            sb.append("')");
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        return sb;
    }

    public Object visit(RelationQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            String propName = "@";
            propName = node.getProperty().equals(this.jcrName(XPathQueryBuilder.FN_POSITION_FULL)) ? propName + this.jcrName(node.getProperty()) : propName + ISO9075.encode(this.jcrName(node.getProperty()));
            if (node.getOperation() == 11) {
                sb.append(propName).append(" eq ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 12) {
                sb.append(propName).append(" = ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 20) {
                sb.append(propName).append(" >= ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 19) {
                sb.append(propName).append(" ge ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 18) {
                sb.append(propName).append(" > ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 17) {
                sb.append(propName).append(" gt ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 22) {
                sb.append(propName).append(" <= ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 21) {
                sb.append(propName).append(" le ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 23) {
                sb.append(this.jcrName(XPathQueryBuilder.JCR_LIKE));
                sb.append("(").append(propName).append(", ");
                this.appendValue(node, sb);
                sb.append(")");
            } else if (node.getOperation() == 16) {
                sb.append(propName).append(" < ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 15) {
                sb.append(propName).append(" lt ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 14) {
                sb.append(propName).append(" != ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 13) {
                sb.append(propName).append(" ne ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 14) {
                sb.append(propName).append(" != ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 26) {
                sb.append(this.jcrName(XPathQueryBuilder.FN_NOT));
                sb.append("(").append(propName).append(")");
            } else if (node.getOperation() == 27) {
                sb.append(propName);
            } else {
                this.exceptions.add(new InvalidQueryException("Invalid operation: " + node.getOperation()));
            }
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        return sb;
    }

    public Object visit(OrderQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        sb.append(" order by");
        OrderQueryNode.OrderSpec[] specs = node.getOrderSpecs();
        String comma = "";
        try {
            for (int i = 0; i < specs.length; ++i) {
                sb.append(comma);
                InternalQName prop = ISO9075.encode(specs[i].getProperty());
                sb.append(" @").append(this.jcrName(prop));
                if (!specs[i].isAscending()) {
                    sb.append(" descending");
                }
                comma = ",";
            }
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        return data;
    }

    private void appendValue(RelationQueryNode node, StringBuffer b) throws RepositoryException {
        if (node.getValueType() == 1) {
            b.append(node.getLongValue());
        } else if (node.getValueType() == 2) {
            b.append(node.getDoubleValue());
        } else if (node.getValueType() == 3) {
            b.append("'").append(node.getStringValue().replaceAll("'", "''")).append("'");
        } else if (node.getValueType() == 4 || node.getValueType() == 5) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.setTime(node.getDateValue());
            b.append(this.jcrName(XPathQueryBuilder.XS_DATETIME));
            b.append("('").append(JCRDateFormat.format(cal)).append("')");
        } else if (node.getValueType() == 6) {
            if (node.getPositionValue() == Integer.MIN_VALUE) {
                b.append("last()");
            } else {
                b.append(node.getPositionValue());
            }
        } else {
            this.exceptions.add(new InvalidQueryException("Invalid type: " + node.getValueType()));
        }
    }

    private String jcrName(InternalQName qname) throws RepositoryException {
        return this.locationFactory.createJCRName(qname).getAsString();
    }
}

