/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.logging.Log;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitions;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.util.StringConverter;
import org.exoplatform.services.jcr.impl.xml.XmlSaveType;
import org.exoplatform.services.jcr.impl.xml.importing.BaseXmlImporter;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportNodeData;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportPropertyData;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentViewImporter
extends BaseXmlImporter {
    private static Log log = ExoLogger.getLogger((String)"jcr.DocNodeImporter");
    private ImportPropertyData xmlCharactersProperty = null;
    private String xmlCharactersPropertyValue = null;

    public DocumentViewImporter(NodeImpl parent, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        super(parent, uuidBehavior, saveType, context);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws RepositoryException {
        StringBuilder text = new StringBuilder();
        text.append(ch, start, length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property:xmltext=" + text + " Parent=" + this.getParent().getQPath().getAsString()));
        }
        if (this.xmlCharactersProperty != null) {
            this.xmlCharactersPropertyValue = this.xmlCharactersPropertyValue + text.toString();
            this.xmlCharactersProperty.setValue(new TransientValueData(this.xmlCharactersPropertyValue));
        } else {
            TransientNodeData nodeData = TransientNodeData.createNodeData(this.getParent(), Constants.JCR_XMLTEXT, Constants.NT_UNSTRUCTURED, this.getNodeIndex(this.getParent(), Constants.JCR_XMLTEXT, null));
            nodeData.setOrderNumber(this.getNextChildOrderNum(this.getParent()));
            this.changesLog.add(new ItemState(nodeData, 1, true, this.getParent().getQPath()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("New node " + nodeData.getQPath().getAsString()));
            }
            ImportPropertyData newProperty = new ImportPropertyData(QPath.makeChildPath(nodeData.getQPath(), Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), 0, 7, nodeData.getIdentifier(), false);
            newProperty.setValue(new TransientValueData(Constants.NT_UNSTRUCTURED));
            this.changesLog.add(new ItemState(newProperty, 1, true, nodeData.getQPath()));
            newProperty = new ImportPropertyData(QPath.makeChildPath(nodeData.getQPath(), Constants.JCR_XMLCHARACTERS), IdGenerator.generate(), 0, 1, nodeData.getIdentifier(), false);
            newProperty.setValue(new TransientValueData(text.toString()));
            this.changesLog.add(new ItemState(newProperty, 1, true, nodeData.getQPath()));
            this.xmlCharactersProperty = newProperty;
            this.xmlCharactersPropertyValue = text.toString();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws RepositoryException {
        this.tree.pop();
        this.xmlCharactersProperty = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Map<String, String> atts) throws RepositoryException {
        String nodeName = ISO9075.decode(qName);
        if ("jcr:root".equals(nodeName)) {
            nodeName = "";
        }
        this.xmlCharactersProperty = null;
        ArrayList<ExtendedNodeType> nodeTypes = new ArrayList<ExtendedNodeType>();
        HashMap<InternalQName, String> propertiesMap = new HashMap<InternalQName, String>();
        ArrayList<InternalQName> mixinNodeTypes = new ArrayList<InternalQName>();
        this.parseAttr(atts, nodeTypes, mixinNodeTypes, propertiesMap, nodeName);
        InternalQName jcrName = this.locationFactory.parseJCRName(nodeName).getInternalName();
        ImportNodeData nodeData = this.createNode(nodeTypes, propertiesMap, mixinNodeTypes, jcrName);
        NodeData parentNodeData = this.getParent();
        this.changesLog.add(new ItemState(nodeData, 1, true, parentNodeData.getQPath()));
        this.tree.push(nodeData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Node : " + nodeData.getQPath().getAsString()));
        }
        Iterator<InternalQName> keys = propertiesMap.keySet().iterator();
        while (keys.hasNext()) {
            PropertyData newProperty = null;
            InternalQName propName = keys.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Property NAME: " + (Object)((Object)propName) + "=" + propertiesMap.get((Object)propName)));
            }
            if (propName.equals((Object)Constants.JCR_PRIMARYTYPE)) {
                if (!this.isChildNodePrimaryTypeAllowed(parentNodeData.getPrimaryTypeName(), parentNodeData.getMixinTypeNames(), propertiesMap.get((Object)Constants.JCR_PRIMARYTYPE))) {
                    throw new ConstraintViolationException("Can't add node " + nodeData.getQName().getAsString() + " to " + parentNodeData.getQPath().getAsString() + " node type " + propertiesMap.get((Object)Constants.JCR_PRIMARYTYPE) + " is not allowed as child's node type for parent node type " + parentNodeData.getPrimaryTypeName().getAsString());
                }
                newProperty = this.endPrimaryType(nodeData.getPrimaryTypeName());
            } else if (propName.equals((Object)Constants.JCR_MIXINTYPES)) {
                newProperty = this.endMixinTypes(mixinNodeTypes, propName);
            } else if (nodeData.isMixReferenceable() && propName.equals((Object)Constants.JCR_UUID)) {
                newProperty = this.endUuid(nodeData, propName);
            } else {
                PropertyDefinition pDef;
                PropertyDefinitions defs;
                try {
                    defs = this.ntManager.findPropertyDefinitions(propName, nodeData.getPrimaryTypeName(), mixinNodeTypes.toArray(new InternalQName[mixinNodeTypes.size()]));
                    pDef = defs.getAnyDefinition();
                }
                catch (RepositoryException e) {
                    if (!this.context.getBoolean("respectPropertyDefinitionsConstraints")) {
                        log.warn((Object)e.getLocalizedMessage());
                        continue;
                    }
                    throw e;
                }
                if (pDef == null || defs == null) {
                    throw new RepositoryException("no propertyDefinition found");
                }
                if (pDef.getRequiredType() == 2) {
                    newProperty = this.endBinary(propertiesMap, newProperty, propName);
                } else {
                    int pType;
                    StringTokenizer spaceTokenizer = new StringTokenizer(propertiesMap.get((Object)propName));
                    ArrayList<ValueData> values = new ArrayList<ValueData>();
                    int n = pType = pDef.getRequiredType() > 0 ? pDef.getRequiredType() : 1;
                    if ("".equals(propertiesMap.get((Object)propName))) {
                        if (pType != 1) continue;
                        Value value = this.session.getValueFactory().createValue(StringConverter.denormalizeString(propertiesMap.get((Object)propName)), pType);
                        values.add(((BaseValue)value).getInternalData());
                    } else {
                        while (spaceTokenizer.hasMoreTokens()) {
                            String elem = spaceTokenizer.nextToken();
                            Value value = this.session.getValueFactory().createValue(StringConverter.denormalizeString(elem), pType);
                            if (log.isDebugEnabled()) {
                                String valueAsString = null;
                                try {
                                    valueAsString = value.getString();
                                }
                                catch (Exception e) {
                                    log.error((Object)("Can't present value as string. " + e.getMessage()));
                                    valueAsString = "[Can't present value as string]";
                                }
                                log.debug((Object)("Property " + PropertyType.nameFromValue((int)pType) + ": " + (Object)((Object)propName) + "=" + valueAsString));
                            }
                            values.add(((BaseValue)value).getInternalData());
                        }
                    }
                    boolean isMultivalue = true;
                    if (values.size() == 1) {
                        if (defs.getDefinition(false) != null) {
                            isMultivalue = false;
                        }
                    } else if (defs.getDefinition(true) == null && defs.getDefinition(false) != null) {
                        throw new ValueFormatException("Can not assign multiple-values Value to a single-valued property " + propName.getAsString() + " node " + jcrName.getName());
                    }
                    newProperty = TransientPropertyData.createPropertyData(this.getParent(), propName, pType, isMultivalue, values);
                    if (nodeData.isMixVersionable()) {
                        this.endVersionable(nodeData, values, propName);
                    }
                }
            }
            this.changesLog.add(new ItemState(newProperty, 1, true, this.getParent().getQPath()));
        }
        if (nodeData.isMixVersionable() && !nodeData.isContainsVersionhistory()) {
            PlainChangesLogImpl changes = new PlainChangesLogImpl();
            new VersionHistoryDataHelper(nodeData, changes, this.session.getTransientNodesManager(), this.session.getWorkspace().getNodeTypeManager(), nodeData.getVersionHistoryIdentifier(), nodeData.getBaseVersionIdentifier());
            for (ItemState state : changes.getAllStates()) {
                if (!state.getData().getQPath().isDescendantOf(Constants.JCR_SYSTEM_PATH, false)) continue;
                this.changesLog.add(state);
            }
        }
    }

    private ImportNodeData createNode(List<ExtendedNodeType> nodeTypes, HashMap<InternalQName, String> propertiesMap, List<InternalQName> mixinNodeTypes, InternalQName jcrName) throws PathNotFoundException, IllegalPathException, RepositoryException {
        ImportNodeData nodeData = new ImportNodeData(this.getParent(), jcrName, this.getNodeIndex(this.getParent(), jcrName, null));
        nodeData.setPrimaryTypeName(this.locationFactory.parseJCRName(propertiesMap.get((Object)Constants.JCR_PRIMARYTYPE)).getInternalName());
        nodeData.setOrderNumber(this.getNextChildOrderNum(this.getParent()));
        nodeData.setMixinTypeNames(mixinNodeTypes.toArray(new InternalQName[mixinNodeTypes.size()]));
        nodeData.setMixReferenceable(this.isNodeType(Constants.MIX_REFERENCEABLE, nodeTypes));
        nodeData.setIdentifier(IdGenerator.generate());
        if (nodeData.isMixReferenceable()) {
            nodeData.setMixVersionable(this.isNodeType(Constants.MIX_VERSIONABLE, nodeTypes));
            String identifier = this.validateUuidCollision(propertiesMap.get((Object)Constants.JCR_UUID));
            if (identifier != null) {
                nodeData.setIdentifier(identifier);
            }
            if (this.uuidBehavior == 2) {
                nodeData.setParentIdentifer(((NodeData)this.tree.peek()).getIdentifier());
            }
        }
        return nodeData;
    }

    private PropertyData endBinary(HashMap<InternalQName, String> propertiesMap, PropertyData newProperty, InternalQName propName) throws RepositoryException {
        try {
            newProperty = TransientPropertyData.createPropertyData(this.getParent(), propName, 2, false, new TransientValueData(new ByteArrayInputStream(Base64.decode((String)propertiesMap.get((Object)propName)))));
        }
        catch (Base64.DecodingException e) {
            throw new RepositoryException((Throwable)e);
        }
        return newProperty;
    }

    private PropertyData endMixinTypes(List<InternalQName> mixinNodeTypes, InternalQName key) {
        ArrayList<ValueData> valuesData = new ArrayList<ValueData>(mixinNodeTypes.size());
        for (InternalQName mixinQname : mixinNodeTypes) {
            valuesData.add(new TransientValueData(mixinQname));
        }
        TransientPropertyData newProperty = TransientPropertyData.createPropertyData(this.getParent(), key, 7, true, valuesData);
        return newProperty;
    }

    private PropertyData endPrimaryType(InternalQName primaryTypeName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property NAME: " + (Object)((Object)primaryTypeName)));
        }
        TransientPropertyData newProperty = TransientPropertyData.createPropertyData(this.getParent(), Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(primaryTypeName));
        return newProperty;
    }

    private PropertyData endUuid(ImportNodeData nodeData, InternalQName key) throws ValueFormatException, UnsupportedRepositoryOperationException, RepositoryException, IllegalStateException {
        Value value = this.session.getValueFactory().createValue(nodeData.getIdentifier(), 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property STRING: " + (Object)((Object)key) + "=" + value.getString()));
        }
        TransientPropertyData newProperty = TransientPropertyData.createPropertyData(this.getParent(), Constants.JCR_UUID, 1, false, new TransientValueData(nodeData.getIdentifier()));
        return newProperty;
    }

    private void endVersionable(ImportNodeData nodeData, List<ValueData> values, InternalQName propName) throws RepositoryException {
        if (propName.equals((Object)Constants.JCR_VERSIONHISTORY)) {
            try {
                nodeData.setVersionHistoryIdentifier(((TransientValueData)values.get(0)).getString());
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            nodeData.setContainsVersionhistory(this.session.getTransientNodesManager().getItemData(nodeData.getVersionHistoryIdentifier()) != null);
        } else if (propName.equals((Object)Constants.JCR_BASEVERSION)) {
            try {
                nodeData.setBaseVersionIdentifier(((TransientValueData)values.get(0)).getString());
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private void parseAttr(Map<String, String> atts, List<ExtendedNodeType> nodeTypes, List<InternalQName> mixinNodeTypes, HashMap<InternalQName, String> props, String nodeName) throws PathNotFoundException, RepositoryException {
        if (!atts.containsKey("jcr:primaryType")) {
            NodeData parent = this.getParent();
            InternalQName nodeNt = this.findNodeType(parent.getPrimaryTypeName(), parent.getMixinTypeNames(), nodeName);
            nodeTypes.add(this.ntManager.getNodeType(nodeNt));
            props.put(Constants.JCR_PRIMARYTYPE, this.locationFactory.createJCRName(nodeNt).getAsString());
        }
        if (atts != null) {
            for (String key : atts.keySet()) {
                InternalQName propInternalQName;
                String attValue = atts.get(key);
                String propName = ISO9075.decode(key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(propName + ":" + attValue));
                }
                if (Constants.JCR_PRIMARYTYPE.equals((Object)(propInternalQName = this.locationFactory.parseJCRName(propName).getInternalName()))) {
                    String primaryNodeType = StringConverter.denormalizeString(attValue);
                    InternalQName ntName = this.locationFactory.parseJCRName(primaryNodeType).getInternalName();
                    nodeTypes.add(this.ntManager.getNodeType(ntName));
                    props.put(propInternalQName, primaryNodeType);
                    continue;
                }
                if (Constants.JCR_MIXINTYPES.equals((Object)propInternalQName)) {
                    String[] amTypes = attValue.split(" ");
                    for (int mi = 0; mi < amTypes.length; ++mi) {
                        amTypes[mi] = StringConverter.denormalizeString(amTypes[mi]);
                        mixinNodeTypes.add(this.locationFactory.parseJCRName(amTypes[mi]).getInternalName());
                        nodeTypes.add((ExtendedNodeType)this.ntManager.getNodeType(amTypes[mi]));
                    }
                    props.put(propInternalQName, null);
                    continue;
                }
                props.put(propInternalQName, attValue);
            }
        }
    }
}

