/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.perf.loanApproval;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.perf.AbstractPerfTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LoanApprovalTest
extends AbstractPerfTestCase {
    public LoanApprovalTest() {
        super("http://orchestra.ow2.org/loanApproval/loanService", "loanService");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        WSRepository.addWS(RiskAssessmentWS.PORTTYPE_QNAME, new RiskAssessmentWS());
        WSRepository.addWS(ApprovalWS.PORTTYPE_QNAME, new ApprovalWS());
    }

    public long launch() {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("firstName", BpelXmlUtil.createElementWithContent((String)"Charles"));
        parts.put("name", BpelXmlUtil.createElementWithContent((String)"Dupont"));
        final int amount = Misc.random((int)0, (int)60000);
        parts.put("amount", BpelXmlUtil.createElementWithContent((String)Integer.toString(amount)));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "request";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "request");
        long endTime = callResult.getEndTime();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                MessageVariable reply = callResult.getMessageCarrier().getMessage();
                if (reply == null) {
                    throw new OrchestraRuntimeException("reply is null");
                }
                Element element = reply.getPartValue("accept");
                if (element == null) {
                    throw new OrchestraRuntimeException("reply.accept is null");
                }
                String accept = element.getTextContent();
                if (amount >= 30000 && accept.equals("yes")) {
                    throw new OrchestraRuntimeException("reply.accept.textContent must be no (amount=" + amount + "), it is : " + accept);
                }
                if (amount < 30000 && accept.equals("no")) {
                    throw new OrchestraRuntimeException("reply.accept.textContent must be yes (amount=" + amount + "), it is : " + accept);
                }
                LoanApprovalTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    public void undeploy() {
        super.undeploy();
        WSRepository.removeWS(RiskAssessmentWS.PORTTYPE_QNAME);
        WSRepository.removeWS(ApprovalWS.PORTTYPE_QNAME);
    }

    public void testLoanApproval() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public String getAlias() {
        return "class.loan";
    }

    public static class RiskAssessmentWS {
        private static final String NAMESPACE = "http://orchestra.ow2.org/loanApproval/riskAssessment";
        public static final QName PORTTYPE_QNAME = new QName("http://orchestra.ow2.org/loanApproval/riskAssessment", "riskAssessmentPT");

        public MessageVariable check(MessageVariable creditInformationRequest) {
            String name = creditInformationRequest.getPartValue("name").getTextContent();
            String level = "low";
            if ("Dupont".equals(name) || "McDonalds".equals(name)) {
                level = "medium";
            } else if ("Kent".equals(name) || "Martin".equals(name)) {
                level = "high";
            }
            Element outputElement = BpelXmlUtil.createElementWithContent((String)level);
            HashMap<String, Document> parts = new HashMap<String, Document>();
            parts.put("level", outputElement.getOwnerDocument());
            return new MessageVariable(parts);
        }
    }

    public static class ApprovalWS {
        private static final String NAMESPACE = "http://orchestra.ow2.org/loanApproval/approval";
        public static final QName PORTTYPE_QNAME = new QName("http://orchestra.ow2.org/loanApproval/approval", "approvalPT");

        public MessageVariable approve(MessageVariable creditInformationRequest) {
            String name = creditInformationRequest.getPartValue("name").getTextContent();
            String amountSt = creditInformationRequest.getPartValue("amount").getTextContent();
            int amount = new Integer(amountSt);
            String accept = "no";
            if ("Dupont".equals(name) || "McDonalds".equals(name)) {
                if (amount < 30000) {
                    accept = "yes";
                }
            } else if ("Kent".equals(name) || "Martin".equals(name)) {
                if (amount < 10000) {
                    accept = "yes";
                }
            } else if (amount < 50000) {
                accept = "yes";
            }
            Element element = BpelXmlUtil.createElementWithContent((String)accept);
            HashMap<String, Document> parts = new HashMap<String, Document>();
            parts.put("accept", element.getOwnerDocument());
            return new MessageVariable(parts);
        }
    }
}

