/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.access;

import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.logging.Log;
import org.exoplatform.services.database.XResources;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class DeleteUserListener
extends UserEventListener {
    protected static Log log = ExoLogger.getLogger((String)"jcr.RepositoryService");
    private RepositoryImpl repository;

    public DeleteUserListener(RepositoryService jcrService) throws Exception {
        this.repository = (RepositoryImpl)jcrService.getCurrentRepository();
    }

    public void preSave(User user, boolean isNew, XResources xresources) {
    }

    public void postSave(User user, boolean isNew, XResources xresources) {
    }

    public void preDelete(User user, XResources xresources) {
        try {
            String[] wsNames = this.repository.getWorkspaceNames();
            for (int i = 0; i < wsNames.length; ++i) {
                SessionImpl session = this.repository.getSystemSession(wsNames[i]);
                QueryManager qManager = session.getWorkspace().getQueryManager();
                Query q = qManager.createQuery("//*[@exo:owner='" + user.getUserName() + "']", "xpath");
                q.execute();
            }
        }
        catch (RepositoryException e) {
            log.error((Object)"RepositoryException while trying to delete a user home dir", (Throwable)e);
        }
    }

    public void postDelete(User user, XResources xresources) {
    }
}

