/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.order;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.jcr.Node;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.webdav.WebDavStatus;
import org.exoplatform.services.jcr.webdav.command.order.OrderMember;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.rest.transformer.SerializableEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderPatchResponseEntity
implements SerializableEntity {
    protected final WebDavNamespaceContext nsContext;
    protected final URI uri;
    protected Node node;
    protected List<OrderMember> members;

    public OrderPatchResponseEntity(WebDavNamespaceContext nsContext, URI uri, Node node, List<OrderMember> members) {
        this.nsContext = nsContext;
        this.uri = uri;
        this.node = node;
        this.members = members;
    }

    public void writeObject(OutputStream outputStream) throws IOException {
        try {
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            xmlStreamWriter.setNamespaceContext(this.nsContext);
            xmlStreamWriter.setDefaultNamespace("DAV:");
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
            xmlStreamWriter.writeNamespace("D", "DAV:");
            xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
            for (int i = 0; i < this.members.size(); ++i) {
                OrderMember member = this.members.get(i);
                xmlStreamWriter.writeStartElement("DAV:", "response");
                xmlStreamWriter.writeStartElement("DAV:", "href");
                String href = this.uri.toASCIIString() + "/" + TextUtil.escape(member.getSegment(), '%', true);
                xmlStreamWriter.writeCharacters(href);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeStartElement("DAV:", "status");
                xmlStreamWriter.writeCharacters(WebDavStatus.getStatusDescription(member.getStatus()));
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
        }
        catch (Exception exc) {
            throw new IOException();
        }
    }
}

