/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.util.Util;

public class UnicastTest
implements Runnable {
    UnicastTest test;
    JChannel channel;
    final String groupname = "UnicastTest-Group";
    Thread t = null;
    long sleep_time = 0L;
    boolean exit_on_end = false;
    boolean busy_sleep = false;

    public void init(String props, long sleep_time, boolean exit_on_end, boolean busy_sleep) throws Exception {
        this.sleep_time = sleep_time;
        this.exit_on_end = exit_on_end;
        this.busy_sleep = busy_sleep;
        this.channel = new JChannel(props);
        this.channel.connect("UnicastTest-Group");
        this.t = new Thread((Runnable)this, "UnicastTest - receiver thread");
        this.t.start();
    }

    public void run() {
        boolean started = false;
        long start = 0L;
        long stop = 0L;
        long current_value = 0L;
        long tmp = 0L;
        long num_values = 0L;
        long total_msgs = 0L;
        long total_time = 0L;
        while (true) {
            try {
                while (true) {
                    Object obj;
                    if ((obj = this.channel.receive(0L)) instanceof View) {
                        System.out.println("** view: " + obj);
                        continue;
                    }
                    if (!(obj instanceof Message)) continue;
                    Message msg = (Message)obj;
                    Data data = (Data)msg.getObject();
                    if (data instanceof StartData) {
                        if (started) {
                            System.err.println("UnicastTest.run(): received START data, but am already processing data");
                            continue;
                        }
                        started = true;
                        current_value = 0L;
                        tmp = 0L;
                        num_values = ((StartData)data).num_values;
                        start = System.currentTimeMillis();
                        continue;
                    }
                    if (!(data instanceof Value)) continue;
                    tmp = ((Value)data).value;
                    if (current_value + 1L != tmp) {
                        System.err.println("-- message received (" + tmp + ") is not 1 greater than " + current_value);
                        continue;
                    }
                    if (++current_value % 1000L == 0L) {
                        System.out.println("received " + current_value);
                    }
                    if (current_value < num_values) continue;
                    stop = System.currentTimeMillis();
                    total_time = stop - start;
                    long msgs_per_sec = (long)((double)num_values / ((double)total_time / 1000.0));
                    System.out.println("-- received " + num_values + " messages in " + total_time + " ms (" + msgs_per_sec + " messages/sec)");
                    started = false;
                    if (!this.exit_on_end) continue;
                    System.exit(0);
                }
            }
            catch (ChannelNotConnectedException not_connected) {
                System.err.println(not_connected);
            }
            catch (ChannelClosedException closed_ex) {
                System.err.println(closed_ex);
            }
            catch (TimeoutException timeout) {
                System.err.println(timeout);
            }
            catch (Throwable t) {
                System.err.println(t);
                started = false;
                current_value = 0L;
                tmp = 0L;
                Util.sleep(1000L);
                continue;
            }
            break;
        }
    }

    public void eventLoop() throws Exception {
        block10: while (true) {
            System.out.print("[1] Send msgs [2] Print view [q] Quit ");
            System.out.flush();
            int c = System.in.read();
            switch (c) {
                case -1: {
                    continue block10;
                }
                case 49: {
                    this.sendMessages();
                    continue block10;
                }
                case 50: {
                    this.printView();
                    continue block10;
                }
                case 51: {
                    continue block10;
                }
                case 52: {
                    continue block10;
                }
                case 53: {
                    continue block10;
                }
                case 54: {
                    continue block10;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
            }
        }
    }

    void sendMessages() throws Exception {
        long num_msgs = this.getNumberOfMessages();
        Address receiver = this.getReceiver();
        Value val = new Value(1L);
        if (receiver == null) {
            System.err.println("UnicastTest.sendMessages(): receiver is null, cannot send messages");
            return;
        }
        System.out.println("sending " + num_msgs + " messages to " + receiver);
        Message msg = new Message(receiver, null, new StartData(num_msgs));
        this.channel.send(msg);
        int i = 1;
        while ((long)i <= num_msgs) {
            val = new Value(i);
            msg = new Message(receiver, null, val);
            if (i % 1000 == 0) {
                System.out.println("-- sent " + i);
            }
            this.channel.send(msg);
            if (this.sleep_time > 0L) {
                Util.sleep(this.sleep_time, this.busy_sleep);
            }
            ++i;
        }
        System.out.println("done sending " + num_msgs + " to " + receiver);
    }

    void printView() {
        System.out.println("\n-- view: " + this.channel.getView() + '\n');
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    long getNumberOfMessages() {
        BufferedReader reader = null;
        String tmp = null;
        try {
            System.out.print("Number of messages to send: ");
            System.out.flush();
            System.in.skip(System.in.available());
            reader = new BufferedReader(new InputStreamReader(System.in));
            tmp = reader.readLine().trim();
            return Long.parseLong(tmp);
        }
        catch (Exception e) {
            System.err.println("UnicastTest.getNumberOfMessages(): " + e);
            return 0L;
        }
    }

    Address getReceiver() {
        Vector<Address> mbrs = null;
        try {
            mbrs = this.channel.getView().getMembers();
            System.out.println("pick receiver from the following members:");
            for (int i = 0; i < mbrs.size(); ++i) {
                if (mbrs.elementAt(i).equals(this.channel.getLocalAddress())) {
                    System.out.println("[" + i + "]: " + mbrs.elementAt(i) + " (self)");
                    continue;
                }
                System.out.println("[" + i + "]: " + mbrs.elementAt(i));
            }
            System.out.flush();
            System.in.skip(System.in.available());
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String tmp = reader.readLine().trim();
            int index = Integer.parseInt(tmp);
            return mbrs.elementAt(index);
        }
        catch (Exception e) {
            System.err.println("UnicastTest.getReceiver(): " + e);
            return null;
        }
    }

    public static void main(String[] args) {
        long sleep_time = 0L;
        boolean exit_on_end = false;
        boolean busy_sleep = false;
        String udp_props = "UDP(mcast_addr=228.8.8.8;mcast_port=45566;ip_ttl=32;ucast_recv_buf_size=32000;ucast_send_buf_size=64000;mcast_send_buf_size=32000;mcast_recv_buf_size=64000;loopback=true):";
        String regular_props = "PING(timeout=1000;num_initial_members=2):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;max_xmit_size=8192):UNICAST(timeout=2000,4000,6000;window_size=100;min_threshold=10;use_gms=false):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8192;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
        String props = udp_props + regular_props;
        String loopback_props = "LOOPBACK:" + regular_props;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                UnicastTest.help();
                return;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-sleep".equals(args[i])) {
                sleep_time = Long.parseLong(args[++i]);
                continue;
            }
            if ("-loopback".equals(args[i])) {
                props = loopback_props;
                continue;
            }
            if ("-exit_on_end".equals(args[i])) {
                exit_on_end = true;
                continue;
            }
            if (!"-busy_sleep".equals(args[i])) continue;
            busy_sleep = true;
        }
        try {
            UnicastTest test = new UnicastTest();
            test.init(props, sleep_time, exit_on_end, busy_sleep);
            test.eventLoop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("UnicastTest [-help] [-props <props>] [-sleep <time in ms between msg sends] [-loopback] [-exit_on_end] [-busy-sleep]");
    }

    public static class Value
    extends Data {
        long value = 0L;

        public Value() {
        }

        Value(long value) {
            this.value = value;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.value);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readLong();
        }
    }

    public static class StartData
    extends Data {
        long num_values = 0L;

        public StartData() {
        }

        StartData(long num_values) {
            this.num_values = num_values;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.num_values);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.num_values = in.readLong();
        }
    }

    public static class Data
    implements Externalizable {
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }
}

