/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class EmailAddressValidator
implements Validator {
    private static final String EMAIL_REGEX = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+";

    public void validate(UIFormInput uiInput) throws Exception {
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        String s = (String)uiInput.getValue();
        if (s.matches(EMAIL_REGEX)) {
            return;
        }
        Object[] args = new Object[]{uiInput.getName(), uiInput.getBindingField()};
        throw new MessageException(new ApplicationMessage("EmailAddressValidator.msg.Invalid-input", args, 1));
    }
}

