/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.tidy;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.html.NodeConfig;
import org.exoplatform.services.html.Tag;
import org.exoplatform.services.html.parser.NodeImpl;
import org.exoplatform.services.html.tidy.TidyToken;
import org.exoplatform.services.token.TokenParser;
import org.exoplatform.services.token.TypeToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTidy {
    private TokenParser tokenPaser = new TokenParser();

    public synchronized List<String> check(char[] data) {
        ArrayList<String> listMsg = new ArrayList<String>();
        TidyToken tokens = new TidyToken();
        try {
            this.tokenPaser.createBeans(tokens, data);
        }
        catch (Exception e) {
            listMsg.add(e.toString());
            return listMsg;
        }
        this.checkCloseElement(listMsg, tokens);
        return listMsg;
    }

    private final void checkCloseElement(List<String> listMsg, TidyToken tokens) {
        if (!tokens.hasNext()) {
            return;
        }
        ArrayList<NodeImpl> openNodes = new ArrayList<NodeImpl>();
        while (tokens.hasNext()) {
            NodeImpl temp = (NodeImpl)tokens.pop();
            NodeConfig config = temp.getConfig();
            if (config.end() == Tag.FORBIDDEN) continue;
            if (temp.getType() == TypeToken.TAG) {
                openNodes.add(temp);
                continue;
            }
            if (openNodes.size() < 1) {
                listMsg.add("No open tag for close node </" + new String(temp.getValue()) + ">");
                continue;
            }
            NodeImpl lastNode = (NodeImpl)openNodes.get(openNodes.size() - 1);
            if (temp.getName() == lastNode.getName()) {
                openNodes.remove(lastNode);
                continue;
            }
            listMsg.add("Expect end tag for <" + new String(lastNode.getValue()) + ">, found </" + new String(temp.getValue()) + ">");
        }
        if (openNodes.size() > 0) {
            listMsg.add("No close tag node <" + new String(((NodeImpl)openNodes.get(openNodes.size() - 1)).getValue()) + ">");
        }
    }
}

