/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.navigation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.ow2.orchestra.console.navigation.ApplicationDefinition;
import org.ow2.orchestra.console.navigation.ConsolePortletsConfig;
import org.ow2.orchestra.console.navigation.ConsolePortletsConfigPlugin;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsolePagesManagementService
implements Startable {
    private DataStorage dataStorage;
    private PortalContainer portalContainer;
    private UserPortalConfigService portalConfigService;
    private OrganizationService organisationService;
    private ConsolePortletsConfig consoleConfig;

    public void addPlugin(ComponentPlugin plugin) throws Exception {
        if (!(plugin instanceof ConsolePortletsConfigPlugin)) {
            throw new RuntimeException(plugin.getClass().getName() + " is an unknown plugin type.");
        }
        this.consoleConfig = ((ConsolePortletsConfigPlugin)plugin).getConsolePortletsConfig();
    }

    public void start() {
    }

    public void stop() {
    }

    public void createUserPages(User user) throws Exception {
        this.portalContainer = PortalContainer.getInstance();
        this.portalConfigService = (UserPortalConfigService)this.portalContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        String pageName = "myapplications";
        String id = "user::" + user.getUserName() + "::" + pageName;
        if (this.portalConfigService.getPage(id, user.getUserName()) == null) {
            PageNavigation userNavigation = new PageNavigation();
            userNavigation.setPriority(1);
            userNavigation.setOwnerId(user.getUserName());
            userNavigation.setOwnerType("user");
            userNavigation.setNodes(new ArrayList());
            Page userPage = this.createNewUserPage(user.getUserName());
            PageNode pageNode = new PageNode();
            pageNode.setPageReference(userPage.getPageId());
            pageNode.setUri("myapp");
            pageNode.setName("myapp");
            pageNode.setLabel("My applications");
            userNavigation.addNode(pageNode);
            this.portalConfigService.create(userPage);
            if (this.portalConfigService.getPageNavigation(userNavigation.getId()) == null) {
                this.portalConfigService.create(userNavigation);
            } else {
                this.portalConfigService.update(userNavigation);
            }
        }
    }

    private Page createNewUserPage(String userName) throws Exception {
        Page page = new Page();
        String pageName = "myapplications";
        String id = "user::" + userName + "::" + pageName;
        UserACL.Permission permission = new UserACL.Permission();
        permission.setName(userName);
        String[] permissions = new String[]{permission.getExpression()};
        page.setPageId(id);
        page.setOwnerType("user");
        page.setOwnerId(userName);
        page.setName(pageName);
        page.setTitle("My applications");
        page.setFactoryId("Desktop");
        page.setAccessPermissions(permissions);
        page.setEditPermission(permission.getExpression());
        ArrayList<Application> childs = new ArrayList<Application>();
        for (ApplicationDefinition appli : this.consoleConfig.getDefaultPortlets()) {
            Application app = new Application();
            app.setInstanceId("user#" + userName + ":/" + appli.getCategory() + "/" + appli.getName() + "/" + appli.getName());
            app.setTitle(appli.getDisplayName());
            if (!"".equals(appli.getType())) {
                app.setApplicationType(appli.getType());
            }
            childs.add(app);
        }
        page.setChildren(childs);
        return page;
    }

    public void updateUserPages(Membership membership) throws Exception {
        Page myApplicationsPage;
        this.portalContainer = PortalContainer.getInstance();
        this.organisationService = (OrganizationService)this.portalContainer.getComponentInstanceOfType(OrganizationService.class);
        this.portalConfigService = (UserPortalConfigService)this.portalContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        Collection userMemberships = this.organisationService.getMembershipHandler().findMembershipsByUser(membership.getUserName());
        HashSet<String> visiblePortlets = new HashSet<String>();
        if (userMemberships != null) {
            userMemberships.add(membership);
            for (Membership m : userMemberships) {
                List<ApplicationDefinition> accessibleApplications = this.consoleConfig.getAccessiblePortlets(m.getGroupId(), m.getMembershipType());
                List<ApplicationDefinition> defaultApplications = this.consoleConfig.getDefaultPortlets();
                if (accessibleApplications != null) {
                    for (ApplicationDefinition appliDef : accessibleApplications) {
                        visiblePortlets.add(appliDef.getName());
                    }
                }
                if (defaultApplications == null) continue;
                for (ApplicationDefinition appliDef : defaultApplications) {
                    visiblePortlets.add(appliDef.getName());
                }
            }
        }
        ArrayList<Page> userPages = this.getPage(membership.getUserName(), null, "myapplications");
        HashMap<String, Application> accessiblePortlets = new HashMap<String, Application>();
        HashSet<ApplicationDefinition> allApplicatons = new HashSet<ApplicationDefinition>();
        for (List<ApplicationDefinition> list : this.consoleConfig.getAccessiblePortlets().values()) {
            allApplicatons.addAll(list);
        }
        allApplicatons.addAll(this.consoleConfig.getDefaultPortlets());
        if (userPages.size() == 1) {
            myApplicationsPage = userPages.get(0);
            for (ApplicationDefinition appli : allApplicatons) {
                if (!visiblePortlets.contains(appli.getName()) || accessiblePortlets.containsKey(appli.getName())) continue;
                Application app = new Application();
                app.setInstanceId("user#" + membership.getUserName() + ":/" + appli.getCategory() + "/" + appli.getName() + "/" + appli.getName());
                app.setTitle(appli.getDisplayName());
                app.setShowInfoBar(Boolean.valueOf(false));
                if (!"".equals(appli.getType())) {
                    app.setApplicationType(appli.getType());
                }
                accessiblePortlets.put(appli.getName(), app);
            }
        } else {
            throw new Exception("[ERROR] The number of \"My Aplications\" pages by user must be only one");
        }
        ArrayList result = new ArrayList();
        result.addAll(accessiblePortlets.values());
        myApplicationsPage.setChildren(result);
        this.portalConfigService.update(myApplicationsPage);
    }

    private ArrayList<Page> getPage(String owner, String ownerType, String name) throws Exception {
        this.portalContainer = PortalContainer.getInstance();
        this.dataStorage = (DataStorage)this.portalContainer.getComponentInstanceOfType(DataStorage.class);
        ArrayList<Page> pages = new ArrayList<Page>();
        Query query = new Query(null, null, null, Page.class);
        query.setOwnerType(ownerType);
        query.setOwnerId(owner);
        query.setName(name);
        PageList pageList = this.dataStorage.find(query);
        List pagesListe = pageList.getAll();
        for (int i = 0; i < pagesListe.size(); ++i) {
            pages.add((Page)pagesListe.get(i));
        }
        return pages;
    }

    public void deleteUserApplications(Membership membership) throws Exception {
        ArrayList<Page> userPages;
        this.portalContainer = PortalContainer.getInstance();
        this.organisationService = (OrganizationService)this.portalContainer.getComponentInstanceOfType(OrganizationService.class);
        this.portalConfigService = (UserPortalConfigService)this.portalContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        Collection userMemberships = this.organisationService.getMembershipHandler().findMembershipsByUser(membership.getUserName());
        HashSet<String> visiblePortlets = new HashSet<String>();
        if (userMemberships != null) {
            userMemberships.remove(membership);
            for (Membership m : userMemberships) {
                List<ApplicationDefinition> accessibleApplications = this.consoleConfig.getAccessiblePortlets(m.getGroupId(), m.getMembershipType());
                List<ApplicationDefinition> defaultApplications = this.consoleConfig.getDefaultPortlets();
                if (accessibleApplications != null) {
                    for (ApplicationDefinition appliDef : accessibleApplications) {
                        visiblePortlets.add(appliDef.getName());
                    }
                }
                if (defaultApplications == null) continue;
                for (ApplicationDefinition appliDef : defaultApplications) {
                    visiblePortlets.add(appliDef.getName());
                }
            }
        }
        if ((userPages = this.getPage(membership.getUserName(), null, "myapplications")) != null && !userPages.isEmpty()) {
            if (userPages.size() == 1) {
                Page myApplicationsPage = userPages.get(0);
                ArrayList oldVisibleApplications = myApplicationsPage.getChildren();
                ArrayList<Application> newVisibleApplications = new ArrayList<Application>();
                if (oldVisibleApplications != null) {
                    for (Application oldVisibleApplication : oldVisibleApplications) {
                        for (String visiblePortlet : visiblePortlets) {
                            if (!oldVisibleApplication.getInstanceId().contains(visiblePortlet)) continue;
                            newVisibleApplications.add(oldVisibleApplication);
                        }
                    }
                }
                myApplicationsPage.setChildren(newVisibleApplications);
                this.portalConfigService.update(myApplicationsPage);
            } else {
                throw new Exception("[ERROR] The number of \"My Aplications\" pages by user must be only one");
            }
        }
    }
}

