/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControl {
    private boolean publicCacheable_ = true;
    private boolean privateCacheable_ = false;
    private boolean noCache_ = false;
    private boolean noStore_ = false;
    private boolean noTransform_ = true;
    private boolean mustRevalidate_ = false;
    private boolean proxyRevalidate_ = false;
    private int maxAge_ = -1;
    private int smaxAge_ = -1;
    private List<String> privateFields_;
    private List<String> noCacheFields_;
    private Map<String, String> cacheExtension_;
    private static final Pattern SPACES_PATTERN = Pattern.compile("\\s");

    public String getAsString() {
        StringBuffer buff = new StringBuffer();
        if (this.isPublicCacheable()) {
            this.appendString(buff, "public");
        }
        if (this.isPrivateCacheable()) {
            this.appendWithParameters(buff, "private", this.getPrivateFields());
        }
        if (this.isNoCache()) {
            this.appendWithParameters(buff, "no-cache", this.getNoCacheFields());
        }
        if (this.isNoStore()) {
            this.appendString(buff, "no-store");
        }
        if (this.isNoTransform()) {
            this.appendString(buff, "no-transform");
        }
        if (this.isMustRevalidate()) {
            this.appendString(buff, "must-revalidate");
        }
        if (this.isProxyRevalidate()) {
            this.appendString(buff, "proxy-revalidate");
        }
        if (this.getMaxAge() >= 0) {
            this.appendString(buff, this.getMaxAge() + "");
        }
        if (this.getSMaxAge() >= 0) {
            this.appendString(buff, this.getSMaxAge() + "");
        }
        for (Map.Entry<String, String> entry : this.getCacheExtension().entrySet()) {
            this.appendWithSingleParameter(buff, entry.getKey(), entry.getValue());
        }
        return buff.toString();
    }

    public boolean isMustRevalidate() {
        return this.mustRevalidate_;
    }

    public void setMustRevalidate(boolean status) {
        this.mustRevalidate_ = status;
    }

    public boolean isProxyRevalidate() {
        return this.proxyRevalidate_;
    }

    public void setProxyRevalidate(boolean status) {
        this.proxyRevalidate_ = status;
    }

    public int getMaxAge() {
        return this.maxAge_;
    }

    public void setMaxAge(int age) {
        this.maxAge_ = age;
    }

    public int getSMaxAge() {
        return this.smaxAge_;
    }

    public void setSMaxAge(int age) {
        this.smaxAge_ = age;
    }

    public boolean isNoCache() {
        return this.noCache_;
    }

    public void setNoCache(boolean state) {
        this.noCache_ = state;
    }

    public void setNoCache(boolean state, List<String> fields) {
        this.noCache_ = state;
        this.noCacheFields_ = fields;
    }

    public List<String> getNoCacheFields() {
        if (this.noCacheFields_ == null) {
            this.noCacheFields_ = new ArrayList<String>();
        }
        return this.noCacheFields_;
    }

    public boolean isPublicCacheable() {
        return this.publicCacheable_;
    }

    public void setPublicCacheable(boolean status) {
        this.publicCacheable_ = status;
    }

    public boolean isPrivateCacheable() {
        return this.privateCacheable_;
    }

    public void setPrivateCacheable(boolean status) {
        this.privateCacheable_ = status;
    }

    public void setPrivateCacheable(boolean status, List<String> fields) {
        this.privateCacheable_ = status;
        this.privateFields_ = fields;
    }

    public List<String> getPrivateFields() {
        if (this.privateFields_ == null) {
            this.privateFields_ = new ArrayList<String>();
        }
        return this.privateFields_;
    }

    public boolean isNoTransform() {
        return this.noTransform_;
    }

    public void setNoTransform(boolean status) {
        this.noTransform_ = status;
    }

    public boolean isNoStore() {
        return this.noStore_;
    }

    public void setNoStore(boolean status) {
        this.noStore_ = status;
    }

    public void setCacheExtension(Map<String, String> extensions) {
        this.cacheExtension_ = extensions;
    }

    public Map<String, String> getCacheExtension() {
        if (this.cacheExtension_ == null) {
            this.cacheExtension_ = new HashMap<String, String>();
        }
        return this.cacheExtension_;
    }

    private void appendString(StringBuffer buff, String s) {
        if (buff.length() > 0) {
            buff.append(", ");
        }
        buff.append(s);
    }

    private void appendWithSingleParameter(StringBuffer buff, String s, String param) {
        StringBuffer localBuff = new StringBuffer();
        localBuff.append(s);
        if (param != null && param.length() > 0) {
            localBuff.append("=");
            localBuff.append(this.addQuotes(param));
        }
        this.appendString(buff, localBuff.toString());
    }

    private void appendWithParameters(StringBuffer buff, String s, List<String> params) {
        this.appendString(buff, s);
        if (params.size() > 0) {
            StringBuffer localBuff = new StringBuffer();
            buff.append("=\"");
            for (String t : params) {
                this.appendString(localBuff, t);
            }
            buff.append(localBuff.toString());
            buff.append("\"");
        }
    }

    private String addQuotes(String s) {
        Matcher macther = SPACES_PATTERN.matcher(s);
        if (macther.find()) {
            return "\"" + s + "\"";
        }
        return s;
    }
}

