/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.application.Application;

public class PortalController
extends HttpServlet {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalController");

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            RootContainer rootContainer = RootContainer.getInstance();
            PortalContainer portalContainer = rootContainer.getPortalContainer(config.getServletContext().getServletContextName());
            portalContainer = rootContainer.createPortalContainer(config.getServletContext());
            PortalContainer.setInstance((PortalContainer)portalContainer);
            WebAppController controller = (WebAppController)portalContainer.getComponentInstanceOfType(WebAppController.class);
            PortalApplication application = new PortalApplication(config);
            application.onInit();
            controller.addApplication((Application)application);
            controller.register((WebRequestHandler)new PortalRequestHandler());
            PortalContainer.setInstance(null);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        log.info((Object)"Init of PortalController Servlet successful");
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            ServletConfig config = this.getServletConfig();
            RootContainer rootContainer = RootContainer.getInstance();
            PortalContainer portalContainer = rootContainer.getPortalContainer(config.getServletContext().getServletContextName());
            PortalContainer.setInstance((PortalContainer)portalContainer);
            WebAppController controller = (WebAppController)portalContainer.getComponentInstanceOfType(WebAppController.class);
            controller.service(req, res);
            PortalContainer.setInstance(null);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }
}

