/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.impl.mock;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class MockCallbackHandler
implements CallbackHandler {
    private String login;
    private char[] password;

    public MockCallbackHandler(String login, String password) {
        this.login = login;
        this.password = password.toCharArray();
    }

    public MockCallbackHandler(String login, char[] password) {
        this.login = login;
        this.password = password;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.login);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbacks[i]).setPassword(this.password);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Callback class not supported");
        }
    }
}

