/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.registry;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.Registry;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.ext.registry.transformer.RegistryEntryInputTransformer;
import org.exoplatform.services.jcr.ext.registry.transformer.RegistryEntryOutputTransformer;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.data.XlinkHref;
import org.exoplatform.services.rest.transformer.OutputEntityTransformer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;
import org.exoplatform.services.rest.transformer.XMLInputTransformer;
import org.exoplatform.services.rest.transformer.XMLOutputTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@URITemplate(value="/registry/{repository}/")
public class RESTRegistryService
implements ResourceContainer {
    private RegistryService regService;
    private ThreadLocalSessionProviderService sessionProviderService;
    private static final String REGISTRY = "registry";
    private static final String EXO_REGISTRY = "exo:registry/";

    public RESTRegistryService(RegistryService regService, ThreadLocalSessionProviderService sessionProviderService) throws Exception {
        this.regService = regService;
        this.sessionProviderService = sessionProviderService;
    }

    @HTTPMethod(value="GET")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=XMLOutputTransformer.class)
    public Response getRegistry(@URIParam(value="repository") String repository, @ContextParam(value="absLocation") String fullURI) throws RepositoryException, RepositoryConfigurationException, ParserConfigurationException {
        this.regService.getRepositoryService().setCurrentRepositoryName(repository);
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Registry.RegistryNode registryEntry = this.regService.getRegistry(sessionProvider);
        if (registryEntry != null) {
            Node registryNode = registryEntry.getNode();
            NodeIterator registryIterator = registryNode.getNodes();
            Document entry = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            XlinkHref xlinkHref = new XlinkHref(fullURI);
            Element root = entry.createElement(REGISTRY);
            xlinkHref.putToElement(root);
            while (registryIterator.hasNext()) {
                NodeIterator entryIterator = registryIterator.nextNode().getNodes();
                while (entryIterator.hasNext()) {
                    Node node = entryIterator.nextNode();
                    Element xmlNode = entry.createElement(node.getName());
                    xlinkHref.putToElement(xmlNode, node.getPath().substring(EXO_REGISTRY.length() + 1));
                    root.appendChild(xmlNode);
                }
            }
            entry.appendChild(root);
            sessionProvider.close();
            return Response.Builder.ok((Object)entry, (String)"text/xml").build();
        }
        sessionProvider.close();
        return Response.Builder.notFound().entity((Object)"NOT_FOUND", "text/plain").transformer((OutputEntityTransformer)new StringOutputTransformer()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HTTPMethod(value="GET")
    @URITemplate(value="/{entryPath}/")
    @OutputTransformer(value=RegistryEntryOutputTransformer.class)
    public Response getEntry(@URIParam(value="repository") String repository, @URIParam(value="entryPath") String entryPath) throws RepositoryException, RepositoryConfigurationException {
        this.regService.getRepositoryService().setCurrentRepositoryName(repository);
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Response response = Response.Builder.serverError().build();
        try {
            RegistryEntry entry = this.regService.getEntry(sessionProvider, entryPath);
            response = Response.Builder.ok((Object)entry, (String)"text/xml").build();
        }
        catch (PathNotFoundException e) {
            response = Response.Builder.notFound().errorMessage("Path not found: " + entryPath).build();
        }
        finally {
            sessionProvider.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HTTPMethod(value="POST")
    @URITemplate(value="/{group}/")
    @InputTransformer(value=RegistryEntryInputTransformer.class)
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response createEntry(RegistryEntry entry, @URIParam(value="repository") String repository, @URIParam(value="group") String groupName, @ContextParam(value="absLocation") String fullURI) throws RepositoryConfigurationException {
        this.regService.getRepositoryService().setCurrentRepositoryName(repository);
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Response response = Response.Builder.serverError().build();
        try {
            this.regService.createEntry(sessionProvider, groupName, entry);
            String location = fullURI + entry.getName();
            response = Response.Builder.created((Object)location, (String)location).mediaType("text/plain").build();
        }
        catch (RepositoryException re) {
            response = Response.Builder.badRequest().entity((Object)"BAD_REQUEST", "text/plain").build();
        }
        finally {
            sessionProvider.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HTTPMethod(value="PUT")
    @URITemplate(value="/{group}/")
    @InputTransformer(value=RegistryEntryInputTransformer.class)
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response recreateEntry(RegistryEntry entry, @URIParam(value="repository") String repository, @URIParam(value="group") String groupName, @ContextParam(value="absLocation") String fullURI) throws RepositoryConfigurationException {
        this.regService.getRepositoryService().setCurrentRepositoryName(repository);
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Response response = Response.Builder.serverError().build();
        try {
            this.regService.recreateEntry(sessionProvider, groupName, entry);
            String location = fullURI + entry.getName();
            response = Response.Builder.created((Object)location, (String)location).mediaType("text/plain").build();
        }
        catch (RepositoryException re) {
            response = Response.Builder.badRequest().entity((Object)"BAD_REQUEST", "text/plain").build();
        }
        finally {
            sessionProvider.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HTTPMethod(value="DELETE")
    @URITemplate(value="/{entryPath}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response removeEntry(@URIParam(value="repository") String repository, @URIParam(value="entryPath") String entryPath) throws RepositoryException, RepositoryConfigurationException {
        this.regService.getRepositoryService().setCurrentRepositoryName(repository);
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Response response = Response.Builder.serverError().build();
        try {
            this.regService.removeEntry(sessionProvider, entryPath);
            response = Response.Builder.noContent().build();
        }
        catch (PathNotFoundException e) {
            response = Response.Builder.notFound().entity((Object)"NOT_FOUND", "text/plain").build();
        }
        finally {
            sessionProvider.close();
        }
        return response;
    }
}

