/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

public class GroupPortalConfigListener
extends GroupEventListener {
    public void preDelete(Group group) throws Exception {
        int i;
        PortalContainer container = PortalContainer.getInstance();
        UserPortalConfigService portalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        String groupId = group.getId().trim();
        if (groupId.charAt(0) == '/') {
            groupId = groupId.substring(1);
        }
        Query<Page> pageQuery = new Query<Page>("group", groupId, Page.class);
        PageList pageList = dataStorage.find(pageQuery);
        for (i = 1; i <= pageList.getAvailablePage(); ++i) {
            List list = pageList.getPage(i);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                portalConfigService.remove((Page)iterator.next());
            }
        }
        Query<PortletPreferences> portletPrefQuery = new Query<PortletPreferences>("group", groupId, PortletPreferences.class);
        pageList = dataStorage.find(portletPrefQuery);
        for (i = 1; i <= pageList.getAvailablePage(); ++i) {
            List list = pageList.getPage(i);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                dataStorage.remove((PortletPreferences)iterator.next());
            }
        }
        PageNavigation navigation = dataStorage.getPageNavigation("group::" + groupId);
        if (navigation != null) {
            portalConfigService.remove(navigation);
        }
    }
}

