/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.Widgets;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.jdbc.UserDAOImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveUserPortalConfigListener
extends Listener<UserDAOImpl, User> {
    public void onEvent(Event<UserDAOImpl, User> event) throws Exception {
        Widgets widgets;
        int i;
        User user = (User)event.getData();
        PortalContainer container = PortalContainer.getInstance();
        UserPortalConfigService portalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        String userName = user.getUserName();
        Query<Page> query = new Query<Page>("user", userName, Page.class);
        PageList pageList = dataStorage.find(query);
        pageList.setPageSize(10);
        for (i = 1; i <= pageList.getAvailablePage(); ++i) {
            List list = pageList.getPage(i);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                portalConfigService.remove((Page)iterator.next());
            }
        }
        Query<PortletPreferences> portletPrefQuery = new Query<PortletPreferences>("user", userName, PortletPreferences.class);
        pageList = dataStorage.find(portletPrefQuery);
        for (i = 1; i <= pageList.getAvailablePage(); ++i) {
            List list = pageList.getPage(i);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                dataStorage.remove((PortletPreferences)iterator.next());
            }
        }
        String id = "user::" + userName;
        PageNavigation navigation = dataStorage.getPageNavigation(id);
        if (navigation != null) {
            portalConfigService.remove(navigation);
        }
        if ((widgets = dataStorage.getWidgets(id)) != null) {
            portalConfigService.remove(widgets);
        }
    }
}

