/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.Comparator;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.portal.UIPortalForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/portal/webui/portal/UIPortalBrowser.gtmpl", events={@EventConfig(listeners={AddNewPortalActionListener.class}), @EventConfig(listeners={DeletePortalActionListener.class}, confirm="UIPortalBrowser.deletePortal")})
public class UIPortalBrowser
extends UIContainer {
    public static String[] BEAN_FIELD = new String[]{"creator", "name", "skin", "accessPermissions", "editPermission"};
    public static String[] SELECT_ACTIONS = new String[]{"DeletePortal"};

    public UIPortalBrowser() throws Exception {
        this.setId("UIPortalBrowser");
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, null, null);
        uiGrid.configure("name", BEAN_FIELD, SELECT_ACTIONS);
        this.addChild((UIComponent)uiGrid.getUIPageIterator());
        uiGrid.getUIPageIterator().setId("UIPortalBrowserPageInterator");
        uiGrid.getUIPageIterator().setRendered(false);
        this.loadPortalConfigs();
    }

    public String event(String name, String beanId) throws Exception {
        if (Util.getUIPortal().getName().equals(beanId)) {
            return super.url(name, beanId);
        }
        return super.event(name, beanId);
    }

    public void loadPortalConfigs() throws Exception {
        DataStorage service = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Query query = new Query(null, null, null, PortalConfig.class);
        PageList pageList = service.find(query, (Comparator)new Comparator<PortalConfig>(){

            @Override
            public int compare(PortalConfig pconfig1, PortalConfig pconfig2) {
                return pconfig1.getName().compareTo(pconfig2.getName());
            }
        });
        pageList.setPageSize(10);
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        uiGrid.setUseAjax(false);
        uiGrid.getUIPageIterator().setPageList(pageList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNewPortalActionListener
    extends EventListener<UIPortalBrowser> {
        public void execute(Event<UIPortalBrowser> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiApp = (UIPortalApplication)((UIPortalBrowser)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            UserACL userACL = (UserACL)uiApp.getApplicationComponent(UserACL.class);
            if (!userACL.hasCreatePortalPermission(prContext.getRemoteUser())) {
                uiApp.addMessage(new ApplicationMessage("UIPortalBrowser.msg.Invalid-createPermission", null));
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPortalForm uiNewPortal = uiMaskWS.createUIComponent(UIPortalForm.class, "CreatePortal", "UIPortalForm");
            uiMaskWS.setUIComponent((UIComponent)uiNewPortal);
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeletePortalActionListener
    extends EventListener<UIPortalBrowser> {
        public void execute(Event<UIPortalBrowser> event) throws Exception {
            String portalName = event.getRequestContext().getRequestParameter("objectId");
            UserPortalConfigService service = (UserPortalConfigService)((UIPortalBrowser)((Object)event.getSource())).getApplicationComponent(UserPortalConfigService.class);
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)((UIPortalBrowser)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            UserPortalConfig config = service.getUserPortalConfig(portalName, prContext.getRemoteUser());
            if (config != null && config.getPortalConfig().isModifiable()) {
                service.removeUserPortalConfig(portalName);
            } else if (config != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPortalBrowser.msg.Invalid-deletePermission", (Object[])new String[]{config.getPortalConfig().getName()}));
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            if (config == null || Util.getUIPortal().getName().equals(portalName)) {
                HttpServletRequest request = prContext.getRequest();
                request.getSession().invalidate();
                prContext.setResponseComplete(true);
                prContext.getResponse().sendRedirect(request.getContextPath());
                return;
            }
            ((UIPortalBrowser)((Object)event.getSource())).loadPortalConfigs();
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        }
    }
}

