/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.Widgets;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class UserPortalConfigListener
extends UserEventListener {
    public void preDelete(User user) throws Exception {
        Widgets widgets;
        int i;
        PortalContainer container = PortalContainer.getInstance();
        UserPortalConfigService portalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        String userName = user.getUserName();
        Query<Page> query = new Query<Page>("user", userName, Page.class);
        PageList pageList = dataStorage.find(query);
        pageList.setPageSize(10);
        for (i = 1; i <= pageList.getAvailablePage(); ++i) {
            List list = pageList.getPage(i);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                portalConfigService.remove((Page)iterator.next());
            }
        }
        Query<PortletPreferences> portletPrefQuery = new Query<PortletPreferences>("user", userName, PortletPreferences.class);
        pageList = dataStorage.find(portletPrefQuery);
        for (i = 1; i <= pageList.getAvailablePage(); ++i) {
            List list = pageList.getPage(i);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                dataStorage.remove((PortletPreferences)iterator.next());
            }
        }
        String id = "user::" + userName;
        PageNavigation navigation = dataStorage.getPageNavigation(id);
        if (navigation != null) {
            portalConfigService.remove(navigation);
        }
        if ((widgets = dataStorage.getWidgets(id)) != null) {
            portalConfigService.remove(widgets);
        }
    }

    public void preSave(User user, boolean isNew) throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        RegistryService registryService = (RegistryService)container.getComponentInstanceOfType(RegistryService.class);
        registryService.start();
        UserPortalConfigService portalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        String userName = user.getUserName();
        String id = "user::" + userName;
        PageNavigation navigation = dataStorage.getPageNavigation(id);
        if (navigation != null) {
            return;
        }
        PageNavigation pageNav = new PageNavigation();
        pageNav.setOwnerType("user");
        pageNav.setOwnerId(userName);
        pageNav.setPriority(5);
        pageNav.setNodes(new ArrayList<PageNode>());
        portalConfigService.create(pageNav);
        Widgets widgets = new Widgets();
        widgets.setOwnerType("user");
        widgets.setOwnerId(userName);
        widgets.setChildren(new ArrayList<Container>());
        portalConfigService.create(widgets);
    }
}

