/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.token.attribute;

import java.util.List;
import org.exoplatform.services.chars.SpecChar;
import org.exoplatform.services.chars.StringTokenizer;
import org.exoplatform.services.common.ThreadSoftRef;
import org.exoplatform.services.token.Node;
import org.exoplatform.services.token.attribute.Attribute;
import org.exoplatform.services.token.attribute.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeParser {
    static ThreadSoftRef<AttributeParser> PARSER = new ThreadSoftRef(AttributeParser.class);

    public static Attributes getAttributes(Node<?> node) {
        return PARSER.getRef().parseAttributes(node);
    }

    private final synchronized Attributes parseAttributes(Node<?> node) {
        String text = String.valueOf(node.getValue());
        text = text.substring(text.toUpperCase().indexOf(node.getName().toString().toUpperCase()) + 1);
        StringTokenizer split = new StringTokenizer(new char[]{'\"'}, new char[]{SpecChar.s, SpecChar.t, SpecChar.b, SpecChar.f, SpecChar.r});
        List<String> elements = split.split(text);
        Attributes list = new Attributes(node);
        for (int i = 0; i < elements.size(); ++i) {
            if (elements.get(i).indexOf("=") <= 0) continue;
            String name = elements.get(i);
            int idx = name.indexOf("=");
            if (idx != name.length() - 1) {
                String value = name.substring(idx + 1);
                name = name.substring(0, idx);
                if (value.charAt(0) == '\'' && value.length() > 1) {
                    value = value.charAt(value.length() - 1) == '\'' ? value.substring(1, value.length() - 1) : value.substring(1, value.length());
                }
                Attribute attr = new Attribute(name, value);
                list.add(attr);
                continue;
            }
            name = name.substring(0, idx);
            Attribute attr = new Attribute(name, "");
            int j = i + 1;
            StringBuilder value = new StringBuilder();
            int start = -1;
            while (j < elements.size()) {
                String txt = elements.get(j).trim();
                if (txt.length() == 0 || txt.equals("\"")) {
                    ++j;
                    ++start;
                    continue;
                }
                if (start == 1 || start == -1 && txt.indexOf("=") > -1) break;
                if (value.length() > 0) {
                    value.append(' ');
                }
                value.append(txt);
                ++j;
            }
            if (value.length() > 0) {
                if (value.charAt(0) == '\'') {
                    value = value.charAt(value.length() - 1) == '\'' && value.length() > 1 ? new StringBuilder(value.substring(1, value.length() - 1)) : new StringBuilder(value.substring(1, value.length()));
                }
                attr.setValue(value.toString());
                list.add(attr);
            }
            i = j - 1;
        }
        list.trimToSize();
        return list;
    }
}

