/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.parser;

import java.util.List;
import org.exoplatform.services.token.TypeToken;
import org.exoplatform.services.xml.parser.XMLNode;
import org.exoplatform.services.xml.parser.XMLToken;

class DOMParser {
    DOMParser() {
    }

    static void parse(XMLToken tokens, XMLNode root) {
        XMLNode temp = (XMLNode)tokens.pop();
        XMLNode current = root;
        while (tokens.hasNext()) {
            if (temp.getType() == TypeToken.CLOSE) {
                current = DOMParser.closeNode(temp.getName(), current);
            } else {
                current.addChild(temp);
                if (temp.getType() == TypeToken.TAG) {
                    current = temp;
                }
            }
            temp = (XMLNode)tokens.pop();
        }
        DOMParser.closeAll(root);
    }

    private static XMLNode closeNode(String name, XMLNode n) {
        XMLNode node = n;
        while (node.getParent() != null) {
            if (node.isOpen() && node.isNode(name)) {
                DOMParser.closeAll(node);
                return node.getParent();
            }
            node = node.getParent();
        }
        return n;
    }

    private static void closeAll(XMLNode node) {
        if (!node.isOpen()) {
            return;
        }
        List<XMLNode> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            XMLNode ele = children.get(i);
            DOMParser.closeAll(ele);
        }
        node.setIsOpen(false);
    }
}

