/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.organization.auth.Identity;
import org.exoplatform.services.organization.auth.PasswordEncrypter;

public class AuthenticationServiceImpl
implements AuthenticationService {
    protected static Log log = ExoLogger.getLogger((String)"authenticationService");
    private ThreadLocal<Identity> currentIdentity_ = new ThreadLocal();
    private Map<String, Identity> identities_ = new HashMap<String, Identity>();
    private ListenerService listenerService_;
    private OrganizationService orgService_;
    private PasswordEncrypter encrypter;

    public AuthenticationServiceImpl(ListenerService listenerService, OrganizationService orgService, PasswordEncrypter encrypter) {
        log.info((Object)"Start AuthenticationService init ...................... ");
        this.listenerService_ = listenerService;
        this.orgService_ = orgService;
        this.encrypter = encrypter;
        log.info((Object)"End AuthenticationService init ...................... ");
    }

    public AuthenticationServiceImpl(ListenerService listenerService, OrganizationService orgService) {
        this(listenerService, orgService, null);
    }

    public boolean login(String userName, String password) throws Exception {
        String psw = password;
        if (this.encrypter != null) {
            psw = new String(this.encrypter.encrypt(password.getBytes()));
        }
        return this.orgService_.getUserHandler().authenticate(userName, psw);
    }

    public void broadcastAuthentication(Identity identity) throws Exception {
        this.identities_.put(identity.getSessionId(), identity);
        this.currentIdentity_.set(identity);
        this.listenerService_.broadcast("exo.service.authentication.login", (Object)this, (Object)identity);
    }

    public Identity getIdentityBySessionId(String sessionId) throws Exception {
        return this.identities_.get(sessionId);
    }

    public Identity getCurrentIdentity() {
        return this.currentIdentity_.get();
    }

    public void setCurrentIdentity(Identity identity) {
        this.currentIdentity_.set(identity);
    }

    public void logout(String sessionId) throws Exception {
        Identity identity = this.identities_.remove(sessionId);
        if (identity == null) {
            throw new Exception("Cannot find the subject for the " + sessionId);
        }
        this.listenerService_.broadcast("exo.service.authentication.logout", (Object)this, (Object)identity);
    }

    public OrganizationService getOrganizationService() {
        return this.orgService_;
    }
}

