/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.core.nodetype;

import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.jcr.core.nodetype.ExtendedItemDefinition;

public class PropertyDefinitions {
    private PropertyDefinition multiDef = null;
    private PropertyDefinition singleDef = null;

    public void setDefinition(PropertyDefinition def) {
        boolean residual = ((ExtendedItemDefinition)def).isResidualSet();
        if (def.isMultiple()) {
            if (residual && this.multiDef == null || !residual) {
                this.multiDef = def;
            }
        } else if (residual && this.singleDef == null || !residual) {
            this.singleDef = def;
        }
    }

    public PropertyDefinition getDefinition(boolean multiple) {
        this.refresh();
        if (multiple && this.multiDef != null) {
            return this.multiDef;
        }
        if (!multiple && this.singleDef != null) {
            return this.singleDef;
        }
        return null;
    }

    public PropertyDefinition getAnyDefinition() {
        this.refresh();
        if (this.multiDef != null) {
            return this.multiDef;
        }
        if (this.singleDef != null) {
            return this.singleDef;
        }
        return null;
    }

    private void refresh() {
        if (this.multiDef != null && this.singleDef != null) {
            if (((ExtendedItemDefinition)this.multiDef).isResidualSet() && !((ExtendedItemDefinition)this.singleDef).isResidualSet()) {
                this.multiDef = null;
            }
            if (((ExtendedItemDefinition)this.singleDef).isResidualSet() && !((ExtendedItemDefinition)this.multiDef).isResidualSet()) {
                this.singleDef = null;
            }
        }
    }

    public String dump() {
        return "Definitions single: " + (this.singleDef == null ? "N/D" : this.singleDef.getName()) + ", multiple: " + (this.multiDef == null ? "N/D" : this.multiDef.getName());
    }
}

