/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

class NotQuery
extends Query {
    private final Query context;
    private Scorer contextScorer;

    NotQuery(Query context) {
        this.context = context;
    }

    protected Weight createWeight(Searcher searcher) {
        return new NotQueryWeight(searcher);
    }

    public String toString(String field) {
        return "NotQuery";
    }

    private class NotQueryScorer
    extends Scorer {
        private final IndexReader reader;
        private int docNo;
        private int contextNo;

        NotQueryScorer(IndexReader reader) {
            super(Similarity.getDefault());
            this.docNo = -1;
            this.contextNo = -1;
            this.reader = reader;
        }

        public boolean next() throws IOException {
            if (this.docNo == -1 && NotQuery.this.contextScorer.next()) {
                this.contextNo = NotQuery.this.contextScorer.doc();
            }
            do {
                ++this.docNo;
            } while (this.reader.isDeleted(this.docNo) && this.docNo < this.reader.maxDoc());
            while (this.contextNo != -1 && this.contextNo == this.docNo) {
                ++this.docNo;
                if (NotQuery.this.contextScorer.next()) {
                    this.contextNo = NotQuery.this.contextScorer.doc();
                    continue;
                }
                this.contextNo = -1;
            }
            return this.docNo < this.reader.maxDoc();
        }

        public int doc() {
            return this.docNo;
        }

        public float score() throws IOException {
            return 1.0f;
        }

        public boolean skipTo(int target) throws IOException {
            if (this.contextNo != -1 && this.contextNo < target) {
                this.contextNo = NotQuery.this.contextScorer.skipTo(target) ? NotQuery.this.contextScorer.doc() : -1;
            }
            this.docNo = target - 1;
            return this.next();
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class NotQueryWeight
    implements Weight {
        private final Searcher searcher;

        NotQueryWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return NotQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            NotQuery.this.contextScorer = NotQuery.this.context.weight(this.searcher).scorer(reader);
            return new NotQueryScorer(reader);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

