/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataRenameVisitor
extends ItemDataTraversingVisitor {
    private static Log log = ExoLogger.getLogger((String)"jcr.ItemDataRenameVisitor");
    protected List<ItemState> itemRenamedStates = new ArrayList<ItemState>();
    private Stack<NodeData> parents = new Stack();
    private final boolean isPersisted;
    private final boolean isEventFire;

    public ItemDataRenameVisitor(NodeData parenData, boolean isPersisted, boolean isEventFile, ItemDataConsumer dataManager, int maxLevel) {
        super(dataManager, maxLevel);
        this.isPersisted = isPersisted;
        this.isEventFire = isEventFile;
        this.parents.push(parenData);
    }

    @Override
    protected void entering(PropertyData property, int level) throws RepositoryException {
        QPath newPath = QPath.makeChildPath(this.getParent().getQPath(), property.getQPath().getName());
        TransientPropertyData tDataCopy = new TransientPropertyData(newPath, property.getIdentifier(), property.getPersistedVersion(), property.getType(), property.getParentIdentifier(), property.isMultiValued());
        tDataCopy.setValues(property.getValues());
        ItemState deletedState = new ItemState(property, 4, this.isEventFire, null, false, this.isPersisted);
        ItemState reanameState = new ItemState(tDataCopy, 32, this.isEventFire, null, false, this.isPersisted);
        this.itemRenamedStates.add(deletedState);
        this.itemRenamedStates.add(reanameState);
    }

    @Override
    protected void entering(NodeData node, int level) throws RepositoryException {
        QPath newPath = QPath.makeChildPath(this.getParent().getQPath(), node.getQPath().getName());
        TransientNodeData newData = new TransientNodeData(newPath, node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), node.getACL());
        ItemState deletedState = new ItemState(node, 4, this.isEventFire, null, false, this.isPersisted);
        ItemState reanameState = new ItemState(newData, 32, this.isEventFire, null, false, this.isPersisted);
        this.itemRenamedStates.add(deletedState);
        this.itemRenamedStates.add(reanameState);
        this.parents.push(newData);
    }

    @Override
    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    @Override
    protected void leaving(NodeData node, int level) throws RepositoryException {
        this.parents.pop();
    }

    private NodeData getParent() {
        return this.parents.peek();
    }

    public List<ItemState> getItemRenamedStates() {
        return this.itemRenamedStates;
    }
}

