/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.jndi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.impl.jndi.BindableRepositoryFactory;

public class BindableRepositoryImpl
implements Serializable,
Referenceable,
ManageableRepository {
    private transient ManageableRepository delegatee = null;

    public BindableRepositoryImpl(ManageableRepository rep) {
        this.delegatee = rep;
    }

    public String[] getDescriptorKeys() {
        return this.delegatee.getDescriptorKeys();
    }

    public String getDescriptor(String key) {
        return this.delegatee.getDescriptor(key);
    }

    public Session login(Credentials credentials) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegatee.login(credentials);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegatee.login(workspaceName);
    }

    public Session login() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegatee.login();
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegatee.login(credentials, workspaceName);
    }

    public Session getSystemSession(String workspaceName) throws RepositoryException {
        return this.delegatee.getSystemSession(workspaceName);
    }

    public String[] getWorkspaceNames() {
        return this.delegatee.getWorkspaceNames();
    }

    public ExtendedNodeTypeManager getNodeTypeManager() {
        return this.delegatee.getNodeTypeManager();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.delegatee.getNamespaceRegistry();
    }

    @Deprecated
    public void initWorkspace(String workspaceName, String rootNodeType) throws RepositoryException {
        this.delegatee.initWorkspace(workspaceName, rootNodeType);
    }

    public boolean isWorkspaceInitialized(String workspaceName) throws RepositoryException {
        return this.delegatee.isWorkspaceInitialized(workspaceName);
    }

    public RepositoryEntry getConfiguration() {
        return this.delegatee.getConfiguration();
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(BindableRepositoryImpl.class.getName(), BindableRepositoryFactory.class.getName(), null);
        ref.add(new StringRefAddr("repositoryName", this.delegatee.getConfiguration().getName()));
        return ref;
    }

    public void createWorkspace(String wsName) throws RepositoryException {
        this.delegatee.createWorkspace(wsName);
    }

    public void importWorkspace(String wsName, InputStream xmlStream) throws RepositoryException, IOException {
        this.delegatee.importWorkspace(wsName, xmlStream);
    }

    public void configWorkspace(WorkspaceEntry wsConfig) throws RepositoryConfigurationException, RepositoryException {
        this.delegatee.configWorkspace(wsConfig);
    }

    public boolean canRemoveWorkspace(String workspaceName) throws NoSuchWorkspaceException {
        return this.delegatee.canRemoveWorkspace(workspaceName);
    }

    public void removeWorkspace(String workspaceName) throws RepositoryException {
        this.delegatee.removeWorkspace(workspaceName);
    }

    public void addItemPersistenceListener(String workspaceName, ItemsPersistenceListener listener) {
        this.delegatee.addItemPersistenceListener(workspaceName, listener);
    }
}

