/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.collections;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Comparator;
import java.util.TreeSet;

public class TreeSetConverter
extends CollectionConverter {
    static /* synthetic */ Class class$java$util$TreeSet;

    public TreeSetConverter(ClassMapper classMapper, String string) {
        super(classMapper, string);
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(class$java$util$TreeSet == null ? (class$java$util$TreeSet = TreeSetConverter.class$("java.util.TreeSet")) : class$java$util$TreeSet);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        TreeSet treeSet = (TreeSet)object;
        Comparator comparator = treeSet.comparator();
        if (comparator == null) {
            hierarchicalStreamWriter.startNode("no-comparator");
            hierarchicalStreamWriter.endNode();
        } else {
            hierarchicalStreamWriter.startNode("comparator");
            hierarchicalStreamWriter.addAttribute("class", this.classMapper.lookupName(comparator.getClass()));
            marshallingContext.convertAnother(comparator);
            hierarchicalStreamWriter.endNode();
        }
        super.marshal(object, hierarchicalStreamWriter, marshallingContext);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        TreeSet treeSet;
        hierarchicalStreamReader.moveDown();
        if (hierarchicalStreamReader.getNodeName().equals("comparator")) {
            String string = hierarchicalStreamReader.getAttribute("class");
            Comparator comparator = (Comparator)unmarshallingContext.convertAnother(null, this.classMapper.lookupType(string));
            treeSet = new TreeSet(comparator);
        } else if (hierarchicalStreamReader.getNodeName().equals("no-comparator")) {
            treeSet = new TreeSet();
        } else {
            throw new ConversionException("TreeSet does not contain <comparator> element");
        }
        hierarchicalStreamReader.moveUp();
        super.populateCollection(hierarchicalStreamReader, unmarshallingContext, treeSet);
        return treeSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

