/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.record.Notes;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.SlideAtom;
import org.apache.poi.hslf.record.SlideListWithText;

public class SlideShow {
    private HSLFSlideShow _hslfSlideShow;
    private Record[] _records;
    private Record[] _mostRecentCoreRecords;
    private Slide[] _slides;
    private org.apache.poi.hslf.model.Notes[] _notes;

    public SlideShow(HSLFSlideShow hslfSlideShow) throws IOException {
        this._hslfSlideShow = hslfSlideShow;
        this._records = this._hslfSlideShow.getRecords();
        byte[] _docstream = this._hslfSlideShow.getUnderlyingBytes();
        this.findMostRecentCoreRecords();
        this.buildSlidesAndNotes();
    }

    private void findMostRecentCoreRecords() {
        int i;
        Object ids;
        Hashtable mostRecentByBytes = new Hashtable();
        for (int i2 = 0; i2 < this._records.length; ++i2) {
            if (!(this._records[i2] instanceof PersistPtrHolder)) continue;
            PersistPtrHolder pph = (PersistPtrHolder)this._records[i2];
            ids = pph.getKnownSlideIDs();
            for (int j = 0; j < ((int[])ids).length; ++j) {
                Integer id = new Integer((int)ids[j]);
                if (!mostRecentByBytes.containsKey(id)) continue;
                mostRecentByBytes.remove(id);
            }
            Hashtable thisSetOfLocations = pph.getSlideLocationsLookup();
            for (int j = 0; j < ((Object)ids).length; ++j) {
                Integer id = new Integer((int)ids[j]);
                mostRecentByBytes.put(id, thisSetOfLocations.get(id));
            }
        }
        this._mostRecentCoreRecords = new Record[mostRecentByBytes.size()];
        Hashtable<Integer, Integer> slideIDtoRecordLookup = new Hashtable<Integer, Integer>();
        int[] allIDs = new int[this._mostRecentCoreRecords.length];
        ids = mostRecentByBytes.keys();
        for (i = 0; i < allIDs.length; ++i) {
            Integer id = (Integer)ids.nextElement();
            allIDs[i] = id;
        }
        Arrays.sort(allIDs);
        for (i = 0; i < allIDs.length; ++i) {
            slideIDtoRecordLookup.put(new Integer(allIDs[i]), new Integer(i));
        }
        for (i = 0; i < this._records.length; ++i) {
            if (!(this._records[i] instanceof PositionDependentRecord)) continue;
            PositionDependentRecord pdr = (PositionDependentRecord)((Object)this._records[i]);
            Integer recordAt = new Integer(pdr.getLastOnDiskOffset());
            for (int j = 0; j < allIDs.length; ++j) {
                Integer thisID = new Integer(allIDs[j]);
                Integer thatRecordAt = (Integer)mostRecentByBytes.get(thisID);
                if (!thatRecordAt.equals(recordAt)) continue;
                Integer storeAtI = (Integer)slideIDtoRecordLookup.get(thisID);
                int storeAt = storeAtI;
                this._mostRecentCoreRecords[storeAt] = this._records[i];
            }
        }
    }

    private void buildSlidesAndNotes() {
        int i;
        int id;
        SlideListWithText.SlideAtomsSet thisSet;
        Vector<Record> slidesV = new Vector<Record>(10);
        Vector<Record> notesV = new Vector<Record>(10);
        Vector metaSheetsV = new Vector(10);
        Vector<Record> slwtV = new Vector<Record>(10);
        Record documentRecord = null;
        for (int i2 = 0; i2 < this._mostRecentCoreRecords.length; ++i2) {
            if (this._mostRecentCoreRecords[i2] instanceof Notes) {
                notesV.add(this._mostRecentCoreRecords[i2]);
            }
            if (this._mostRecentCoreRecords[i2] instanceof org.apache.poi.hslf.record.Slide) {
                slidesV.add(this._mostRecentCoreRecords[i2]);
            }
            if (this._records[i2].getRecordType() != 1000L) continue;
            documentRecord = this._mostRecentCoreRecords[i2];
        }
        Record[] docChildren = documentRecord.getChildRecords();
        for (int i3 = 0; i3 < docChildren.length; ++i3) {
            if (!(docChildren[i3] instanceof SlideListWithText)) continue;
            slwtV.add(docChildren[i3]);
        }
        HashSet<Integer> uniqueSlideIDs = new HashSet<Integer>();
        Vector<SlideListWithText.SlideAtomsSet> setsV = new Vector<SlideListWithText.SlideAtomsSet>();
        for (int i4 = 0; i4 < slwtV.size(); ++i4) {
            SlideListWithText slwt = (SlideListWithText)slwtV.get(i4);
            SlideListWithText.SlideAtomsSet[] thisSets = slwt.getSlideAtomsSets();
            for (int j = 0; j < thisSets.length; ++j) {
                thisSet = thisSets[j];
                setsV.add(thisSet);
                id = thisSet.getSlidePersistAtom().getSlideIdentifier();
                Integer idI = new Integer(id);
                if (!uniqueSlideIDs.contains(idI)) {
                    uniqueSlideIDs.add(idI);
                    continue;
                }
                System.err.println("** WARNING - Found two SlideAtomsSets for a given slide (" + id + ") - only using the first one **");
            }
        }
        int[] slideIDs = new int[uniqueSlideIDs.size()];
        int pos = 0;
        Iterator getIDs = uniqueSlideIDs.iterator();
        while (getIDs.hasNext()) {
            Integer id2 = (Integer)getIDs.next();
            slideIDs[pos] = id2;
            ++pos;
        }
        Arrays.sort(slideIDs);
        SlideListWithText.SlideAtomsSet[] slideAtomSets = new SlideListWithText.SlideAtomsSet[slideIDs.length];
        for (i = 0; i < setsV.size(); ++i) {
            thisSet = (SlideListWithText.SlideAtomsSet)setsV.get(i);
            id = thisSet.getSlidePersistAtom().getSlideIdentifier();
            int arrayPos = -1;
            for (int j = 0; j < slideIDs.length; ++j) {
                if (slideIDs[j] != id) continue;
                arrayPos = j;
            }
            slideAtomSets[arrayPos] = thisSet;
        }
        this._notes = new org.apache.poi.hslf.model.Notes[notesV.size()];
        for (i = 0; i < this._notes.length; ++i) {
            this._notes[i] = new org.apache.poi.hslf.model.Notes((Notes)notesV.get(i));
        }
        this._slides = new Slide[slidesV.size()];
        for (i = 0; i < this._slides.length; ++i) {
            org.apache.poi.hslf.record.Slide slideRecord = (org.apache.poi.hslf.record.Slide)slidesV.get(i);
            SlideListWithText.SlideAtomsSet atomSet = null;
            if (i < slideAtomSets.length) {
                atomSet = slideAtomSets[i];
            }
            org.apache.poi.hslf.model.Notes thisNotes = null;
            SlideAtom sa = slideRecord.getSlideAtom();
            int notesID = sa.getNotesID();
            if (notesID != 0) {
                for (int k = 0; k < this._notes.length; ++k) {
                    if (this._notes[k].getSheetNumber() != notesID) continue;
                    thisNotes = this._notes[k];
                }
            }
            this._slides[i] = new Slide(slideRecord, thisNotes, atomSet);
        }
    }

    public void write(OutputStream out) throws IOException {
        this._hslfSlideShow.write(out);
    }

    public Record[] getMostRecentCoreRecords() {
        return this._mostRecentCoreRecords;
    }

    public Slide[] getSlides() {
        return this._slides;
    }

    public org.apache.poi.hslf.model.Notes[] getNotes() {
        return this._notes;
    }
}

