/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.logging.Log;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitions;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.xml.XmlSaveType;
import org.exoplatform.services.jcr.impl.xml.importing.ContentImporter;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportNodeData;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXmlImporter
implements ContentImporter {
    private final Log log = ExoLogger.getLogger((String)"jcr.ImporterBase");
    private final XmlSaveType saveType;
    protected final InvocationContext context;
    protected final Stack<NodeData> tree = new Stack();
    protected final PlainChangesLogImpl changesLog;
    protected LocationFactory locationFactory;
    protected final NodeTypeManagerImpl ntManager;
    protected final SessionImpl session;
    protected final int uuidBehavior;

    public BaseXmlImporter(NodeImpl parent, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        this.saveType = saveType;
        this.context = context;
        this.session = parent.getSession();
        this.ntManager = (NodeTypeManagerImpl)this.session.getRepository().getNodeTypeManager();
        this.locationFactory = this.session.getLocationFactory();
        this.uuidBehavior = uuidBehavior;
        this.tree.push((NodeData)parent.getData());
        this.changesLog = new PlainChangesLogImpl(this.session.getId());
    }

    public int getNextChildOrderNum(NodeData parentData) {
        int max = -1;
        for (ItemState itemState : this.changesLog.getAllStates()) {
            int cur;
            ItemData stateData = itemState.getData();
            if (!this.isParent(stateData, parentData) || !stateData.isNode() || (cur = ((NodeData)stateData).getOrderNumber()) <= max) continue;
            max = cur;
        }
        return ++max;
    }

    public int getNodeIndex(NodeData parentData, InternalQName name, String skipIdentifier) throws PathNotFoundException, IllegalPathException, RepositoryException {
        int newIndex = 1;
        NodeDefinitionImpl nodedef = this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(name, parentData.getPrimaryTypeName(), parentData.getMixinTypeNames());
        ItemData sameNameNode = null;
        try {
            sameNameNode = this.session.getTransientNodesManager().getItemData(parentData, new QPathEntry(name, 0));
        }
        catch (PathNotFoundException e) {
            return newIndex;
        }
        List<ItemState> transientAddChilds = this.getItemStatesList(parentData, name, 1, skipIdentifier);
        List<ItemState> transientDeletedChilds = this.getItemStatesList(parentData, new QPathEntry(name, 0), 4, null);
        if (!(nodedef.allowsSameNameSiblings() || sameNameNode == null && transientAddChilds.size() <= 0)) {
            if (sameNameNode != null && transientDeletedChilds.size() < 1) {
                throw new ItemExistsException("The node  already exists in " + sameNameNode.getQPath().getAsString() + " and same name sibling is not allowed ");
            }
            if (transientAddChilds.size() > 0) {
                throw new ItemExistsException("The node  already exists in add state   and same name sibling is not allowed ");
            }
        }
        newIndex += transientAddChilds.size();
        List<NodeData> existedChilds = this.session.getTransientNodesManager().getChildNodesData(parentData);
        for (NodeData child : existedChilds) {
            if (transientDeletedChilds.size() != 0 || !child.getQPath().getName().equals((Object)name)) continue;
            ++newIndex;
        }
        return newIndex;
    }

    public XmlSaveType getSaveType() {
        return this.saveType;
    }

    @Override
    public void registerNamespace(String prefix, String uri) {
        try {
            this.session.getWorkspace().getNamespaceRegistry().getPrefix(uri);
        }
        catch (NamespaceException e) {
            try {
                this.session.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, uri);
            }
            catch (NamespaceException e1) {
                throw new RuntimeException(e1);
            }
            catch (RepositoryException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void save() throws RepositoryException {
        Collections.sort(this.changesLog.getAllStates(), new PathSorter());
        if (this.log.isDebugEnabled()) {
            String str = "";
            for (int i = 0; i < this.changesLog.getAllStates().size(); ++i) {
                str = str + " " + ItemState.nameFromValue(this.changesLog.getAllStates().get(i).getState()) + "\t\t" + this.changesLog.getAllStates().get(i).getData().getIdentifier() + "\t" + "isPersisted=" + this.changesLog.getAllStates().get(i).isPersisted() + "\t" + "isEventFire=" + this.changesLog.getAllStates().get(i).isEventFire() + "\t" + "isInternallyCreated=" + this.changesLog.getAllStates().get(i).isInternallyCreated() + "\t" + this.changesLog.getAllStates().get(i).getData().getQPath().getAsString() + "\n";
            }
            this.log.debug((Object)str);
        }
        try {
            switch (this.saveType) {
                case SESSION: {
                    for (ItemState itemState : this.changesLog.getAllStates()) {
                        if (itemState.isAdded()) {
                            this.session.getTransientNodesManager().update(itemState, false);
                            continue;
                        }
                        if (!itemState.isDeleted()) continue;
                        this.session.getTransientNodesManager().delete(itemState.getData());
                    }
                    break;
                }
                case WORKSPACE: {
                    this.session.getTransientNodesManager().getTransactManager().save(this.changesLog);
                }
            }
        }
        catch (ItemNotFoundException e) {
            throw new ConstraintViolationException((Throwable)e);
        }
        catch (InvalidItemStateException e) {
            throw new ConstraintViolationException((Throwable)e);
        }
    }

    private List<ItemState> getItemStatesList(NodeData parentData, InternalQName name, int state, String skipIdentifier) {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        for (ItemState itemState : this.changesLog.getAllStates()) {
            ItemData stateData = itemState.getData();
            if (!this.isParent(stateData, parentData) || !stateData.getQPath().getName().equals((Object)name) || state != 0 && state != itemState.getState() || stateData.getIdentifier().equals(skipIdentifier)) continue;
            states.add(itemState);
        }
        return states;
    }

    protected boolean isChildNodePrimaryTypeAllowed(InternalQName parentNodeType, InternalQName[] parentMixinNames, String nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        List<ExtendedNodeType> parenNt = this.getAllNodeTypes(parentNodeType, parentMixinNames);
        for (ExtendedNodeType extendedNodeType : parenNt) {
            if (!extendedNodeType.isChildNodePrimaryTypeAllowed(nodeTypeName)) continue;
            return true;
        }
        return false;
    }

    protected InternalQName findNodeType(InternalQName parentNodeType, InternalQName[] parentMixinNames, String name) throws RepositoryException, ConstraintViolationException {
        List<ExtendedNodeType> nodeTypes = this.getAllNodeTypes(parentNodeType, parentMixinNames);
        String residualNodeTypeName = null;
        for (ExtendedNodeType extendedNodeType : nodeTypes) {
            NodeDefinition[] nodeDefs = extendedNodeType.getChildNodeDefinitions();
            for (int i = 0; i < nodeDefs.length; ++i) {
                NodeDefinition nodeDef = nodeDefs[i];
                if (nodeDef.getName().equals(name)) {
                    if (nodeDef.getDefaultPrimaryType() == null) continue;
                    return this.locationFactory.parseJCRName(nodeDef.getDefaultPrimaryType().getName()).getInternalName();
                }
                if (!nodeDef.getName().equals("*") || nodeDef.getDefaultPrimaryType() == null) continue;
                residualNodeTypeName = nodeDef.getDefaultPrimaryType().getName();
            }
        }
        if (residualNodeTypeName == null) {
            throw new ConstraintViolationException("Can not define node-type for node " + name + ", parent node type " + parentNodeType.getAsString());
        }
        return this.locationFactory.parseJCRName(residualNodeTypeName).getInternalName();
    }

    private List<ExtendedNodeType> getAllNodeTypes(InternalQName parentNodeType, InternalQName[] parentMixinNames) throws NoSuchNodeTypeException, RepositoryException {
        ArrayList<ExtendedNodeType> parenNt = new ArrayList<ExtendedNodeType>();
        parenNt.add(this.ntManager.getNodeType(parentNodeType));
        if (parentMixinNames != null) {
            for (int i = 0; i < parentMixinNames.length; ++i) {
                parenNt.add(this.ntManager.getNodeType(parentMixinNames[i]));
            }
        }
        return parenNt;
    }

    private boolean isParent(ItemData data, ItemData parent) {
        String id2;
        String id1 = data.getParentIdentifier();
        if (id1 == (id2 = parent.getIdentifier())) {
            return true;
        }
        if (id1 == null && id2 != null) {
            return false;
        }
        return id1.equals(id2);
    }

    @Deprecated
    protected ItemData getLocalItemData(NodeData parentData, QPathEntry name, String skipIdentifier) {
        ItemData item = null;
        List<ItemState> states = this.getItemStatesList(parentData, name, 0, skipIdentifier);
        ItemState state = states.get(states.size() - 1);
        if (!state.isDeleted()) {
            item = state.getData();
        }
        return item;
    }

    protected NodeData getParent() {
        return this.tree.peek();
    }

    protected PropertyDefinition getPropertyDefinition(InternalQName propertyName, List<ExtendedNodeType> nodeTypes) {
        PropertyDefinition pdResidual = null;
        for (ExtendedNodeType nt : nodeTypes) {
            PropertyDefinitions pds = nt.getPropertyDefinitions(propertyName);
            PropertyDefinition pd = pds.getAnyDefinition();
            if (pd == null) continue;
            if (((PropertyDefinitionImpl)pd).isResidualSet()) {
                pdResidual = pd;
                continue;
            }
            return pd;
        }
        return pdResidual;
    }

    protected boolean isNodeType(InternalQName name, List<ExtendedNodeType> nodeTypes) {
        for (ExtendedNodeType nt : nodeTypes) {
            if (!nt.isNodeType(name)) continue;
            return true;
        }
        return false;
    }

    protected void replaceFirstState(QPath path, int state, ItemState itemState) {
        for (int i = 0; i < this.changesLog.getAllStates().size(); ++i) {
            if (this.changesLog.getAllStates().get(i).getState() != state || !this.changesLog.getAllStates().get(i).getData().getQPath().equals(path)) continue;
            this.changesLog.getAllStates().set(i, itemState);
            break;
        }
        throw new IllegalStateException("replace fail");
    }

    protected String validateUuidCollision(String identifier) throws RepositoryException {
        NodeData parentNodeData = this.getParent();
        ItemDataRemoveVisitor visitor = null;
        List<ItemState> removedStates = null;
        if (identifier != null) {
            try {
                ItemImpl sameUuidItem = this.session.getTransientNodesManager().getItemByIdentifier(identifier, false);
                if (sameUuidItem != null) {
                    switch (this.uuidBehavior) {
                        case 0: {
                            identifier = null;
                            break;
                        }
                        case 1: {
                            if (!sameUuidItem.isNode() || !((NodeImpl)sameUuidItem).isNodeType("mix:referenceable")) {
                                throw new RepositoryException("An incoming referenceable node has the same UUID as a identifier of non mix:referenceable node already existing in the workspace!");
                            }
                            visitor = new ItemDataRemoveVisitor(this.session, true);
                            sameUuidItem.getData().accept(visitor);
                            removedStates = visitor.getRemovedStates();
                            this.changesLog.addAll(removedStates);
                            break;
                        }
                        case 2: {
                            if (!sameUuidItem.isNode() || !((NodeImpl)sameUuidItem).isNodeType("mix:referenceable")) {
                                throw new RepositoryException("An incoming referenceable node has the same UUID as a identifier of non mix:referenceable node already existing in the workspace!");
                            }
                            parentNodeData = (NodeData)sameUuidItem.getParent().getData();
                            visitor = new ItemDataRemoveVisitor(this.session, true);
                            sameUuidItem.getData().accept(visitor);
                            removedStates = visitor.getRemovedStates();
                            this.changesLog.addAll(removedStates);
                            this.tree.push(ImportNodeData.createCopy((TransientNodeData)parentNodeData));
                            break;
                        }
                        case 3: {
                            throw new ItemExistsException("An incoming referenceable node has the same UUID as a node already existing in the workspace!");
                        }
                    }
                }
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
        return identifier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathSorter
    implements Comparator<ItemState> {
        private PathSorter() {
        }

        @Override
        public int compare(ItemState i1, ItemState i2) {
            int sign = 0;
            if (i1.getState() != i2.getState()) {
                sign = i2.isDeleted() ? 1 : -1;
            }
            return sign;
        }
    }
}

