/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.skin.SkinService;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIToolbar;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/webui/core/UIToolbar.gtmpl", events={@EventConfig(listeners={RollbackActionListener.class}), @EventConfig(listeners={AbortActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={FinishActionListener.class})})
public class UIPortalManagementControlBar
extends UIToolbar {
    public UIPortalManagementControlBar() throws Exception {
        this.setToolbarStyle("ControlToolbar");
        this.setJavascript("Preview", "onClick='eXo.portal.UIPortal.switchMode(this);'");
    }

    public void save() throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        UIPortalApplication uiPortalApp = (UIPortalApplication)this.getAncestorOfType(UIPortalApplication.class);
        PortalConfig portalConfig = PortalDataMapper.toPortal(uiPortal);
        UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        configService.update(portalConfig);
        uiPortalApp.getUserPortalConfig().setPortal(portalConfig);
        PortalRequestContext prContext = Util.getPortalRequestContext();
        String remoteUser = prContext.getRemoteUser();
        String ownerUser = prContext.getPortalOwner();
        UserPortalConfig userPortalConfig = configService.getUserPortalConfig(ownerUser, remoteUser);
        if (userPortalConfig != null) {
            uiPortal.setModifiable(userPortalConfig.getPortalConfig().isModifiable());
        } else {
            uiPortal.setModifiable(false);
        }
        LocaleConfigService localeConfigService = (LocaleConfigService)uiPortalApp.getApplicationComponent(LocaleConfigService.class);
        LocaleConfig localeConfig = localeConfigService.getLocaleConfig(portalConfig.getLocale());
        if (localeConfig == null) {
            localeConfig = localeConfigService.getDefaultLocaleConfig();
        }
        uiPortalApp.setLocale(localeConfig.getLocale());
        uiPortalApp.setSkin(uiPortal.getSkin());
        prContext.refreshResourceBundle();
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        skinService.invalidatePortalSkinCache(uiPortal.getName(), uiPortal.getSkin());
    }

    public String event(String name) throws Exception {
        if (name.equals("Finish") || name.equals("Abort")) {
            return super.url(name);
        }
        return super.event(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbortActionListener
    extends EventListener<UIPortalManagementControlBar> {
        public void execute(Event<UIPortalManagementControlBar> event) throws Exception {
            UIPortalApplication uiPortalApp = (UIPortalApplication)((UIPortalManagementControlBar)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UserPortalConfigService configService = (UserPortalConfigService)uiPortalApp.getApplicationComponent(UserPortalConfigService.class);
            configService.update(uiPortalApp.getUserPortalConfig().getPortalConfig());
            String remoteUser = prContext.getRemoteUser();
            String ownerUser = prContext.getPortalOwner();
            UserPortalConfig userPortalConfig = configService.getUserPortalConfig(ownerUser, remoteUser);
            if (userPortalConfig == null) {
                HttpServletRequest request = prContext.getRequest();
                String portalName = URLEncoder.encode(Util.getUIPortal().getName(), "UTF-8");
                String redirect = request.getContextPath() + "/public/" + portalName + "/";
                prContext.getResponse().sendRedirect(redirect);
            }
            UIPortal uiPortal = (UIPortal)uiWorkingWS.createUIComponent(prContext, UIPortal.class, null, null);
            PortalDataMapper.toUIPortal(uiPortal, userPortalConfig);
            UIPortal oldUIPortal = (UIPortal)uiWorkingWS.getChild(UIPortal.class);
            uiWorkingWS.setBackupUIPortal(oldUIPortal);
            uiWorkingWS.replaceChild(oldUIPortal.getId(), (UIComponent)uiPortal);
            uiWorkingWS.setRenderedChild(UIPortal.class);
            PageNodeEvent<UIPortal> pnevent = new PageNodeEvent<UIPortal>(uiPortal, "ChangePageNode", null, uiPortal.getSelectedNode().getUri());
            uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FinishActionListener
    extends EventListener<UIPortalManagementControlBar> {
        public void execute(Event<UIPortalManagementControlBar> event) throws Exception {
            UIPortalManagementControlBar uiPortalManagement = (UIPortalManagementControlBar)((Object)event.getSource());
            uiPortalManagement.save();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UserPortalConfigService configService = (UserPortalConfigService)uiPortalManagement.getApplicationComponent(UserPortalConfigService.class);
            UserPortalConfig userPortalConfig = configService.getUserPortalConfig(prContext.getPortalOwner(), prContext.getRemoteUser());
            if (userPortalConfig == null) {
                HttpServletRequest request = prContext.getRequest();
                String portalName = URLEncoder.encode(Util.getUIPortal().getName(), "UTF-8");
                String redirect = request.getContextPath() + "/public/" + portalName + "/";
                prContext.getResponse().sendRedirect(redirect);
            }
            UIPortal uiPortal = Util.getUIPortal();
            PageNodeEvent<UIPortal> pnevent = new PageNodeEvent<UIPortal>(uiPortal, "ChangePageNode", null, uiPortal.getSelectedNode().getUri());
            uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPortalManagementControlBar> {
        public void execute(Event<UIPortalManagementControlBar> event) throws Exception {
            UIPortalManagementControlBar uiPortalManagement = (UIPortalManagementControlBar)((Object)event.getSource());
            uiPortalManagement.save();
            Util.updateUIApplication(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RollbackActionListener
    extends EventListener<UIPortalManagementControlBar> {
        public void execute(Event<UIPortalManagementControlBar> event) throws Exception {
            UIPortalApplication uiPortalApp = (UIPortalApplication)((UIPortalManagementControlBar)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            UIWorkspace uiWorkingWS = Util.updateUIApplication(event);
            UserPortalConfigService configService = (UserPortalConfigService)uiPortalApp.getApplicationComponent(UserPortalConfigService.class);
            configService.update(uiPortalApp.getUserPortalConfig().getPortalConfig());
            PortalRequestContext prContext = Util.getPortalRequestContext();
            String remoteUser = prContext.getRemoteUser();
            String ownerUser = prContext.getPortalOwner();
            UserPortalConfig userPortalConfig = configService.getUserPortalConfig(ownerUser, remoteUser);
            UIPortal oldUIPortal = (UIPortal)uiWorkingWS.getChild(UIPortal.class);
            uiWorkingWS.setBackupUIPortal(oldUIPortal);
            if (userPortalConfig != null) {
                UIPortal uiPortal = (UIPortal)uiWorkingWS.createUIComponent(prContext, UIPortal.class, null, null);
                PortalDataMapper.toUIPortal(uiPortal, userPortalConfig);
                uiWorkingWS.replaceChild(oldUIPortal.getId(), (UIComponent)uiPortal);
            }
            uiWorkingWS.setRenderedChild(UIPortal.class);
        }
    }
}

