/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.basic.AbstractBasicConverter;
import com.thoughtworks.xstream.core.SequenceGenerator;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class ReferenceByIdMarshaller
extends TreeMarshaller {
    private ObjectIdDictionary references = new ObjectIdDictionary();
    private IDGenerator idGenerator;

    public ReferenceByIdMarshaller(HierarchicalStreamWriter hierarchicalStreamWriter, ConverterLookup converterLookup, ClassMapper classMapper, IDGenerator iDGenerator) {
        super(hierarchicalStreamWriter, converterLookup, classMapper);
        this.idGenerator = iDGenerator;
    }

    public ReferenceByIdMarshaller(HierarchicalStreamWriter hierarchicalStreamWriter, ConverterLookup converterLookup, ClassMapper classMapper) {
        this(hierarchicalStreamWriter, converterLookup, classMapper, new SequenceGenerator(1));
    }

    public void convertAnother(Object object) {
        Converter converter = this.converterLookup.lookupConverterForType(object.getClass());
        if (this.isImmutableBasicType(converter)) {
            converter.marshal(object, this.writer, this);
        } else {
            String string = this.references.lookupId(object);
            if (string != null) {
                this.writer.addAttribute("reference", string);
            } else {
                String string2 = this.idGenerator.next();
                this.writer.addAttribute("id", string2);
                this.references.associateId(object, string2);
                converter.marshal(object, this.writer, this);
            }
        }
    }

    private boolean isImmutableBasicType(Converter converter) {
        return converter instanceof AbstractBasicConverter;
    }

    public static interface IDGenerator {
        public String next();
    }
}

