/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.webui.validator;

import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class NumberInRangeValidator
implements Validator {
    private Long minItern = 0L;
    private Long maxItern = 0L;

    public NumberInRangeValidator(Long min, Long max) {
        this.maxItern = max;
        this.minItern = min;
    }

    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        UIComponent uiComponent = (UIComponent)uiInput;
        UIForm uiForm = (UIForm)uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getLabel(uiInput.getName());
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        label = label.trim();
        if (label.charAt(label.length() - 1) == ':') {
            label = label.substring(0, label.length() - 1);
        }
        String s = (String)uiInput.getValue();
        boolean error = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(Character.isDigit(c) || s.charAt(0) == '-' && i == 0)) {
                error = false;
                Object[] args = new Object[]{label, uiInput.getBindingField()};
                throw new MessageException(new ApplicationMessage("NumberFormatValidator.msg.Invalid-number", args, 1));
            }
            error = true;
        }
        if (error) {
            Long num = Long.decode(s);
            if (this.minItern > num || this.maxItern < num) {
                Object[] args = new Object[]{label, this.minItern.toString(), this.maxItern.toString()};
                throw new MessageException(new ApplicationMessage("NumberInRangeValidator.msg.Invalid-number", args, 1));
            }
        }
    }
}

